-- Global so as to test them more easily
BL_max_vel = 16.5
BL_max_vel2 = 22
BL_smoothness = 1.5
BL_correction = 2

-- to avoid triggering huge propulsor jumps, that may happen due to issues with
-- physics (it seems to happen more online than locally, maybe packet issues, no idea).
-- Bl_max_vel2 stops those spikes that make possible to e.g. climb Station2 bridge
-- in two clicks AND go over the enemies' wall
core.register_globalstep(function ()
  for _, player in ipairs(arena_lib.get_players_in_minigame("block_league", true)) do
    local pl_y = player:get_velocity().y
    if pl_y > BL_max_vel then
      local diff = pl_y - BL_max_vel
      player:add_velocity({x=0, y=-diff/BL_smoothness, z=0})
    end
    if pl_y >= BL_max_vel2 then
      local diff = pl_y - BL_max_vel2
      player:add_velocity({x=0, y=-diff*BL_correction, z=0})
    end
  end
end)