block_league.SPEED = 2.5
block_league.SHOOT_SPEED_MULTIPLIER = 0.6
block_league.SPEED_LOW = block_league.SPEED * block_league.SHOOT_SPEED_MULTIPLIER

block_league.PHYSICS = {
  speed = block_league.SPEED,
  jump = 1.5,
  gravity = 1.15,
  sneak_glitch = true,
  new_move = true
}

-- max time in seconds to get assists
block_league.ASSIST_TIME = 5

-- in seconds. Playing more than this won't give players any exp until the week is
-- over (it resets on Thursday, 00:00:00, and their seconds are registered only when
-- they're inside a Block League match as players). This setting prevents heavy grinding,
-- trying to push for a healthier playtime. By default is 14 hours.
block_league.WEEKLY_PLAYING_TIME_LIMIT = 60 * 60 * 2 * 7

-- xp required for every weapon
block_league.XP_REQUIRED_PER_LV = {
  500,
  1000,
  1000,
  --[[1000, TEMP: Beta
  1000,
  1000,
  1000,
  1000,
  1000,
  1000]]
}

-- if enabled, it prints many messages (to all players) to get useful information
-- and allows to run commands such as `/bladmin reset <p_name>`
block_league.DEBUG_MODE = false
