local IS_PARTIES_ENABLED = core.get_modpath("parties")



arena_lib.on_assign_team("block_league", function(arena, p_name)
  local sum_team1, sum_team2 = 0, 0
  local team_orange_amount = arena.players_amount_per_team[1]
  local team_blue_amount = arena.players_amount_per_team[2]
  local max_players = arena.max_players

  -- se non si è in gruppo..
  if not IS_PARTIES_ENABLED or not parties.is_player_in_party(p_name) then
    -- se c'è rimasto solo un posto, scelta obbligata
    if team_orange_amount == max_players then
      return 2
    elseif team_blue_amount == max_players then
      return 1
    end

  -- se invece si è in gruppo.. (si tenga presente che arena_lib ha già verificato
  -- che ci fosse abbastanza posto in almeno una squadra)
  else
    -- se qualcunə è già in partita, metti nella stessa squadra e fine
    for _, pl_name in ipairs(parties.get_party_members(p_name, true)) do
      if arena_lib.is_player_playing(pl_name) then
        return arena.players[pl_name].teamID
      end
    end

    local party_size = #parties.get_party_members(p_name, true)

    -- se una delle due squadre non ha abbastanza posto, scelta obbligata
    if team_orange_amount + party_size > max_players then
      return 2
    elseif team_orange_amount + party_size > max_players then
      return 1
    end
  end

  -- se c'è una differenza di numero, metti automaticamente nell'altra squadra
  if team_orange_amount - team_blue_amount ~= 0 then
    return team_orange_amount > team_blue_amount and 2 or 1
  end

  -- sennò calcola la differenza di livello e metti nella squadra col lv più basso
  for pl_name, pl_data in pairs(arena.players) do
    if pl_data.teamID == 1 then
      sum_team1 = sum_team1 + block_league.get_player_level(pl_name) + 1 -- + 1 perché sennò i lv 0 non hanno peso nel conteggio
    else
      sum_team2 = sum_team2 + block_league.get_player_level(pl_name) + 1
    end
  end

  return sum_team1 > sum_team2 and 2 or 1
end)