local S = core.get_translator("block_league")

local cmd_bleague = chatcmdbuilder.register("bleague", {})
local cmd_bladmin = chatcmdbuilder.register("bladmin", {
  params = "help",
  description = S("mod management"),
  privs = { blockleague_admin = true }
})

--------------------------------bladmin-------------------------------------------

cmd_bladmin:sub("testkit", function(sender)
  block_league.enter_test_mode(sender)
end)

-- need it to allow command blocks to run /bladmin @nearest, or I don't know how to open players' profiles through pressure plates and the like
cmd_bladmin:sub("profile :playername", function(sender, p_name)
  if arena_lib.is_player_in_arena(sender) or not core.get_player_by_name(p_name) then
    core.chat_send_player(sender, core.colorize("#e6482e", S("[!] You can't perform this action right now!")))
    return end

  block_league.show_profile(p_name)
end)

cmd_bladmin:sub("print xp_stats", function(sender)
  block_league.print_server_xp_stats(sender)
end)

cmd_bladmin:sub("print p_stats :playername", function(sender, p_name)
  local success, output = block_league.print_player_stats(p_name)

  if success then
    block_league.print(sender, output)
  else
    block_league.print_error(sender, output)
  end
end)

--------------- equipaggiamento: armi
cmd_bladmin:sub("unlock :playername weapon :wname", function(sender, p_name, w_name)
  local success, output = block_league.unlock_weapon(p_name, "block_league:" .. w_name)

  if success then
    block_league.print(sender, output)
  else
    block_league.print_error(sender, output)
  end
end)

cmd_bladmin:sub("unlockvar :playername weapon :wname :varname", function(sender, p_name, w_name, var_name)
  local success, output = block_league.unlock_weapon_variant(p_name, "block_league:" .. w_name, "block_league:" .. var_name)

  if success then
    block_league.print(sender, output)
  else
    block_league.print_error(sender, output)
  end
end)

-- TODO: prima devo far in modo che si possa giocare con meno di 3 armi, perché se
-- ce l'hanno equipaggiata devo anche disequipaggiarla
--[[cmd_bladmin:sub("remove :playername weapon :wname", function(sender, p_name, w_name)
  local success, output = block_league.remove_weapon(p_name, "block_league:" .. w_name)

  if success then
    block_league.print(sender, output)
  else
    block_league.print_error(sender, output)
  end
end)]]

cmd_bladmin:sub("removevar :playername weapon :wname :varname", function(sender, p_name, w_name, var_name)
  local success, output = block_league.remove_weapon_variant(p_name, "block_league:" .. w_name, "block_league:" .. var_name)

  if success then block_league.print(sender, output)
  else            block_league.print_error(sender, output)
  end
end)

--------------- equipaggiamento: abilità TODO
cmd_bladmin:sub("unlock :playername skill :sname", function(sender, p_name, c_name)
end)

cmd_bladmin:sub("unlockvar :playername skill :sname :varname", function(sender, p_name, s_name, var_name)
end)

cmd_bladmin:sub("remove :playername skill :sname", function(sender, p_name, c_name)
end)

cmd_bladmin:sub("removevar :playername skill :sname", function(sender, p_name, c_name)
end)

--------------- sistema d'esperienza
cmd_bladmin:sub("lv set :playername :weapon :lv:int", function(sender, p_name, w_name, lv)
  local success, output = block_league.set_level(p_name, "block_league:" .. w_name, lv)

  if success then block_league.print(sender, output)
  else            block_league.print_error(sender, output)
  end
end)

cmd_bladmin:sub("xp set :playername :weapon :amount:int", function(sender, p_name, w_name, xp)
  local success, output = block_league.set_xp(p_name, "block_league:" .. w_name, xp)

  if success then block_league.print(sender, output)
  else            block_league.print_error(sender, output)
  end
end)

cmd_bladmin:sub("reset :playername confirm", function(sender, p_name)
  local success, output = block_league.flush_xp(p_name)

  if success then block_league.print(sender, output)
  else            block_league.print_error(sender, output)
  end
end)


-- aiuto
cmd_bladmin:sub("help", function(sender)
  core.chat_send_player(sender,
    core.colorize("#ffff00", S("COMMANDS")) .. "\n"
    .. core.colorize("#eeee00", S("Testing")) .. "\n"
    .. core.colorize("#00ffff", "/bladmin testkit") .. ": " .. S("enter test mode, granting you a minimal kit and BL in-game physics") .. "\n\n"
    .. core.colorize("#eeee00", S("Player data")) .. "\n"
    .. core.colorize("#00ffff", "/bladmin xp set") .. " <" .. S("player") .. "> <" .. S("weapon") .. "> <" .. S("amount") .. ">\n"
    .. core.colorize("#00ffff", "/bladmin lv set") .. " <" .. S("player") .. "> <" .. S("weapon") .. "> <" .. S("level") .. ">\n"
    .. core.colorize("#00ffff", "/bladmin print p_stats") .." <" .. S("player") .. ">\n"
    .. core.colorize("#00ffff", "/bladmin print xp_stats") .. ": " .. S("prints several server stats regarding the experience system. IT CAUSES A BIG LAG SPIKE, only use it when no important actions are in progress") .. "\n\n"
    .. core.colorize("#eeee00", S("Weapons and skills")) .. "\n"
    .. core.colorize("#00ffff", "/bladmin unlock") .. " <" .. S("player") .. "> " .. core.colorize("#00ffff","weapon") .. " <" .. S("weapon") .. ">\n"
    .. core.colorize("#00ffff", "/bladmin unlockvar") .. " <" .. S("player") .. "> " .. core.colorize("#00ffff","weapon") .. " <" .. S("weapon") .. "> <" .. S("variant") .. ">\n"
    .. core.colorize("#00ffff", "/bladmin removevar") .. " <" .. S("player") .. "> " .. core.colorize("#00ffff","weapon") .. " <" .. S("weapon") .. "> <" .. S("variant") .. ">"
  )
end)





--------------------------------bleague-------------------------------------------

cmd_bleague:sub("profile", function(sender)
  if arena_lib.is_player_in_arena(sender) then
    core.chat_send_player(sender, core.colorize("#e6482e", S("[!] You can't perform this action right now!")))
    return end

  block_league.show_profile(sender)
end)