local S = core.get_translator("block_league")

local temp_data = {}     -- KEY: p_name; VAL: {w_name = {amount, completed}}
local licences = {
    -- possibili parametri futuri: `time` x quelle a tempo
    ["block_league:smg"] = {
      {type = "KILL", action = "ANY", goal = 3, desc = S("Kill @1 enemies", 3)},
      {type = "KILL", action = "ANY", goal = 5, desc = S("Kill @1 enemies", 5)},
      {type = "KILL", action = "ANY", goal = 10, desc = S("Kill @1 enemies", 10), reward = {type = "SKIN", item = "block_league:smg_silver"}},
    },
    ["block_league:sword"] = {
      {type = "KILL", action = "ANY", goal = 3, desc = S("Kill @1 enemies", 3)},
      {type = "KILL", action = "ANY", goal = 5, desc = S("Kill @1 enemies", 5)},
      {type = "KILL", action = "ANY", goal = 10, desc = S("Kill @1 enemies", 10), reward = {type = "SKIN", item = "block_league:sword_silver"}},
    },
    ["block_league:pixelgun"] = {
      {type = "KILL", action = "ANY", goal = 3, desc = S("Kill @1 enemies", 3)},
      {type = "KILL", action = "ANY", goal = 5, desc = S("Kill @1 enemies", 5)},
      {type = "KILL", action = "ANY", goal = 10, desc = S("Kill @1 enemies", 10), reward = {type = "SKIN", item = "block_league:pixelgun_silver"}},
    },
    ["block_league:peacifier"] = {
      {type = "KILL", action = "ANY", goal = 3, desc = S("Kill @1 enemies", 3)},
      {type = "KILL", action = "ANY", goal = 5, desc = S("Kill @1 enemies", 5)},
      {type = "KILL", action = "ANY", goal = 10, desc = S("Kill @1 enemies", 10), reward = {type = "SKIN", item = "block_league:peacifier_silver"}},
    },
    ["block_league:sentry_gun"] = {
      {type = "KILL", action = "ANY", goal = 2, desc = S("Kill @1 enemies", 2)},
      {type = "KILL", action = "ANY", goal = 3, desc = S("Kill @1 enemies", 3)},
      {type = "KILL", action = "ANY", goal = 5, desc = S("Kill @1 enemies", 5), reward = {type = "SKIN", item = "block_league:sentry_gun_silver"}},
    },
    ["block_league:bomb"] = {
      {type = "KILL", action = "ANY", goal = 3, desc = S("Kill @1 enemies", 3)},
      {type = "KILL", action = "ANY", goal = 5, desc = S("Kill @1 enemies", 5)},
      {type = "KILL", action = "ANY", goal = 10, desc = S("Kill @1 enemies", 10), reward = {type = "SKIN", item = "block_league:bomb_silver"}},
    }
}



-- non esporre
function block_league.init_licences_progress(p_name, gamemode)
  if gamemode == 0 then return end  -- niente licenze nel tutorial

  for _, w_name in ipairs(block_league.get_equipped_weapons(p_name, true)) do
    if block_league.is_weapon_exp_enabled(w_name) and block_league.can_get_licence(p_name, w_name) then
      temp_data[p_name] = temp_data[p_name] or {}
      temp_data[p_name][w_name] = {amount = 0, completed = false}
    end
  end
end



-- non esporre
function block_league.empty_licences_progress(p_name)
  temp_data[p_name] = nil
end



-- non esporre
function block_league.calc_licence(p_amount, p_name, w_name, goal)
  if block_league.has_exceeded_weekly_time(p_name) then return end

  if p_amount >= 4 and block_league.can_get_licence(p_name, w_name) then
    local w_lv = block_league.get_weapon_lv(p_name, w_name)
    local licence = block_league.get_licence_info(w_name, w_lv+1)
    local progress = block_league.get_licence_progress(p_name, w_name)

    if not progress.completed and licence.type == "KILL" and goal > 0 then
      block_league.set_licence_progress(p_name, w_name, progress.amount + goal)
      block_league.HUD_licences_update_progress(p_name, w_name)
    end
  end
end





----------------------------------------------
--------------------UTILS---------------------
----------------------------------------------

function block_league.has_licence_in_progress(p_name)
  return temp_data[p_name] ~= nil
end





----------------------------------------------
-----------------GETTERS----------------------
----------------------------------------------

--- @param w_name string
--- @param lv number level unlocked by completing the licence
function block_league.get_licence_description(w_name, lv)
  return licences[w_name] and licences[w_name][lv].desc
end



function block_league.get_licence_info(w_name, lv)
  return licences[w_name] and licences[w_name][lv]
end



function block_league.can_get_licence(p_name, w_name)
  return block_league.get_xp_required_for_lv_up(p_name, w_name) == 0 and block_league.get_weapon_lv(p_name, w_name) < block_league.get_weapons_max_lv()
end



-- non esporre
function block_league.get_licence_progress(p_name, w_name)
  return temp_data[p_name] and temp_data[p_name][w_name]
end





----------------------------------------------
-----------------SETTERS----------------------
----------------------------------------------

-- non esporre
function block_league.set_licence_progress(p_name, w_name, amount)
  local p_data = temp_data[p_name]

  if not p_data or not p_data[w_name] or p_data[w_name].completed or not arena_lib.is_player_playing(p_name, "block_league") then return end

  local w_data = p_data[w_name]
  local w_lv = block_league.get_weapon_lv(p_name, w_name)

  w_data.amount = amount

  if w_data.amount >= licences[w_name][w_lv+1].goal then
    w_data.completed = true
  end
end