function block_league.is_in_the_air(obj_ref)
  local obj_pos = obj_ref:get_pos()
  local node_beneath = vector.new(obj_pos.x, obj_pos.y - 0.4, obj_pos.z)
  local is_in_the_air = core.get_node(node_beneath).name == "air"

  return is_in_the_air
end



function block_league.calc_avg_players_amount(arena)
  local initial_time = arena.initial_time
  local markers = arena.join_leave_markers
  local sum = 0

  for i, data in ipairs(markers) do
    if i == #markers then break end
    block_league.print_debug(string.format("Avg players amount, found new marker. Sum = %d + %d * (%d - %d)",
        sum, data.amount, data.timestamp, markers[i+1].timestamp))

    sum = sum + data.amount * (data.timestamp - markers[i+1].timestamp)
  end

  local current_time = arena.current_time or initial_time -- se è ancora in caricamento, current_time non esiste

  block_league.print_debug(string.format("Avg players amount = %d / (%d - %d) ---> %f",
      sum, initial_time, current_time, sum / (initial_time - current_time)))

  return sum / (initial_time - current_time)
end



function block_league.play_sound_to_player(p_name, sound)
  weapons_lib.play_sound(sound, p_name)
end



function block_league.remove_player_entities(p_entities) -- p_stats.entities
  for _, obj in pairs(p_entities) do
    local entity = obj:get_luaentity()
    if entity then
      if not entity._is_dying then
        if entity._kill then
          entity:_kill()
        else
          obj:remove()
        end
      end
    end
  end

  p_entities = {}
end



function block_league.is_entity_in_player_team(p_name, entity)
  if not entity._teamID then return end

  local teamID = arena_lib.get_teamID(p_name)

  if not teamID then return end

  return entity._teamID == teamID
end



function block_league.print_error(p_name, msg)
	core.chat_send_player(p_name, core.colorize("#e6482e", arena_lib.mods["block_league"].prefix .. " " .. msg))
end



function block_league.print_debug(msg)
  if not block_league.DEBUG_MODE then return end

  core.chat_send_all(arena_lib.mods["block_league"].prefix .. " DEBUG: " .. msg)
end



function block_league.print(p_name, msg)
	core.chat_send_player(p_name, arena_lib.mods["block_league"].prefix .. " " .. msg)
end