local function load_folder()
  local wrld_dir = core.get_worldpath() .. "/skins"
  local files = core.get_dir_list(wrld_dir, false)

  local modpath = core.get_modpath("collectible_skins")

  -- se la cartella delle skin non esiste/è vuota, copio la cartella base `skins`
  -- dentro quella del mondo
  if not next(files) then
    local src_dir = core.get_modpath("collectible_skins") .. "/IGNOREME"
    core.cpdir(src_dir, wrld_dir)
    os.remove(wrld_dir .. "/README.md")
  end

  --v------------------ LEGACY UPDATE, to remove in 2.0 -------------------v
  local i18n_dir = modpath .. "/locale/skins"

  for _, dir_name in ipairs(core.get_dir_list(modpath .. "/locale", true)) do
    if dir_name == "skins" then
      core.rmdir(i18n_dir, true)
    end
  end

  local tr_script = io.open(wrld_dir .. "/po_translation_updater.py", "r")

  if not tr_script then
    local orig = io.open(modpath .. "/IGNOREME/po_translation_updater.py")
    local instructions = io.open(modpath .. "/IGNOREME/instructions.txt")
    os.remove(wrld_dir .. "instructions.txt")
    core.safe_file_write(wrld_dir .. "/po_translation_updater.py", orig:read("*a"))
    core.safe_file_write(wrld_dir .. "/instructions.txt", instructions:read("*a"))
  else
    tr_script:close()
  end
  --^------------------ LEGACY UPDATE, to remove in 2.0 -------------------^

  -- carico quel che posso dalla cartella del mondo (non davvero media dinamici,
  -- dato che vengon eseguiti all'avvio del server)
  local function iterate_dirs(dir)
    for _, f_name in pairs(core.get_dir_list(dir, false)) do
      core.dynamic_add_media({filepath = dir .. "/" .. f_name}, function(name) end)
    end
    for _, subdir in pairs(core.get_dir_list(dir, true)) do
      iterate_dirs(dir .. "/" .. subdir)
    end
  end

  -- TEMP MT 5.9: per ora non si possono aggiungere contenuti dinamici all'avvio
  -- del server. Poi rimuovi anche 2° param da dynamic_add_media qui in alto
  core.after(0.1, function()
    iterate_dirs(wrld_dir .. "/locale")
    iterate_dirs(wrld_dir .. "/textures")
  end)


end



load_folder()

dofile(core.get_worldpath("collectible_skins") .. "/skins/SETTINGS.lua")
