# country_lib docs

## 1. API

### 1.1 Getters

* `country_lib.get_countries()`: (table) returns a table containing alpha-2 codes as key and the full (translated) name as a value, e.g. `{AD = "Andorra"}`
* `country_lib.get_country_codes()`: (table) returns a table containing all the alpha-2 codes. Format `{"AD", "AE"}`
* `country_lib.get_country_name(code)`: (string) returns the name of the country corresponding to `code`
  * `code` must be upper case
  * If it's not a valid code, it returns `"Unknown"`
* `country_lib.get_country_flag(code)`: (string) returns the texture of the flag of the country corresponding to `code`
  * `code` must be upper case
  * If it's not a valid code, it returns a flag with a question mark inside

## 2. About the author(s)
I'm Zughy (Marco), a professional Italian pixel artist who fights for FOSS and digital ethics. If this library spared you a lot of time and you want to support me somehow, please consider donating on [Liberapay](https://liberapay.com/Zughy/)
