local S = core.get_translator("country_lib")

local COUNTRY_CODES_TBL = {
  "AD","AE","AF","AG","AI","AL","AM","AO","AQ","AR","AS","AT","AU","AW","AX","AZ","BA","BB","BD","BE","BF","BG","BH","BI","BJ","BL","BM","BN",
  "BO","BQ","BR","BS","BT","BV","BW","BY","BZ","CA","CC","CD","CF","CG","CH","CI","CK","CL","CM","CN","CO","CR","CU","CV","CW","CX","CY","CZ",
  "DE","DJ","DK","DM","DO","DZ","EC","EE","EG","EH","ER","ES","ET","FI","FJ","FK","FM","FO","FR","GA","GB","GD","GE","GF","GG","GH","GI","GL",
  "GM","GN","GP","GQ","GR","GS","GT","GU","GW","GY","HK","HM","HN","HR","HT","HU","ID","IE","IL","IM","IN","IO","IQ","IR","IS","IT","JE","JM",
  "JO","JP","KE","KG","KH","KI","KM","KN","KP","KR","KW","KY","KZ","LA","LB","LC","LI","LK","LR","LS","LT","LU","LV","LY","MA","MC","MD","ME",
  "MF","MG","MH","MK","ML","MM","MN","MO","MP","MQ","MR","MS","MT","MU","MV","MW","MX","MY","MZ","NA","NC","NE","NF","NG","NI","NL","NO","NP",
  "NR","NU","NZ","OM","PA","PE","PF","PG","PH","PK","PL","PM","PN","PR","PS","PT","PW","PY","QA","RE","RO","RS","RU","RW","SA","SB","SC","SD",
  "SE","SG","SH","SI","SJ","SK","SL","SM","SN","SO","SR","SS","ST","SV","SX","SY","SZ","TC","TD","TF","TG","TH","TJ","TK","TL","TM","TN","TO",
  "TR","TT","TV","TW","TZ","UA","UG","UM","US","UY","UZ","VA","VC","VE","VG","VI","VN","VU","WF","WS","YE","YT","ZA","ZM","ZW"
}

local COUNTRIES = {
  AD = S("Andorra"),
  AE = S("United Arab Emirates"),
  AF = S("Afghanistan"),
  AG = S("Antigua and Barbuda"),
  AI = S("Anguilla"),
  AL = S("Albania"),
  AM = S("Armenia"),
  AO = S("Angola"),
  AQ = S("Antarctica"),
  AR = S("Argentina"),
  AS = S("American Samoa"),
  AT = S("Austria"),
  AU = S("Australia"),
  AW = S("Aruba"),
  AX = S("Åland Islands"),
  AZ = S("Azerbaijan"),
  BA = S("Bosnia and Herzegovina"),
  BB = S("Barbados"),
  BD = S("Bangladesh"),
  BE = S("Belgium"),
  BF = S("Burkina Faso"),
  BG = S("Bulgaria"),
  BH = S("Bahrain"),
  BI = S("Burundi"),
  BJ = S("Benin"),
  BL = S("Saint Barthélemy"),
  BM = S("Bermuda"),
  BN = S("Brunei"),
  BO = S("Bolivia"),
  BQ = S("Bonaire, Sint Eustatius and Saba"),
  BR = S("Brazil"),
  BS = S("Bahamas"),
  BT = S("Bhutan"),
  BV = S("Bouvet Island"),
  BW = S("Botswana"),
  BY = S("Belarus"),
  BZ = S("Belize"),
  CA = S("Canada"),
  CC = S("Cocos Islands"),
  CD = S("Democratic Republic of the Congo"),
  CF = S("Central African Republic"),
  CG = S("Congo"),
  CH = S("Switzerland"),
  CI = S("Côte d'Ivoire"),
  CK = S("Cook Islands"),
  CL = S("Chile"),
  CM = S("Cameroon"),
  CN = S("China"),
  CO = S("Colombia"),
  CR = S("Costa Rica"),
  CU = S("Cuba"),
  CV = S("Cabo Verde"),
  CW = S("Curaçao"),
  CX = S("Christmas Island"),
  CY = S("Cyprus"),
  CZ = S("Czechia"),
  DE = S("Germany"),
  DJ = S("Djibouti"),
  DK = S("Denmark"),
  DM = S("Dominica"),
  DO = S("Dominican Republic"),
  DZ = S("Algeria"),
  EC = S("Ecuador"),
  EE = S("Estonia"),
  EG = S("Egypt"),
  EH = S("Western Sahara"),
  ER = S("Eritrea"),
  ES = S("Spain"),
  ET = S("Ethiopia"),
  FI = S("Finland"),
  FJ = S("Fiji"),
  FK = S("Falkland Islands"),
  FM = S("Micronesia"),
  FO = S("Faroe Islands"),
  FR = S("France"),
  GA = S("Gabon"),
  GB = S("United Kingdom"),
  GD = S("Grenada"),
  GE = S("Georgia"),
  GF = S("French Guiana"),
  GG = S("Guernsey"),
  GH = S("Ghana"),
  GI = S("Gibraltar"),
  GL = S("Greenland"),
  GM = S("Gambia"),
  GN = S("Guinea"),
  GP = S("Guadeloupe"),
  GQ = S("Equatorial Guinea"),
  GR = S("Greece"),
  GS = S("South Georgia and the South Sandwich Islands"),
  GT = S("Guatemala"),
  GU = S("Guam"),
  GW = S("Guinea-Bissau"),
  GY = S("Guyana"),
  HK = S("Hong Kong"),
  HM = S("Heard Island and McDonald Islands"),
  HN = S("Honduras"),
  HR = S("Croatia"),
  HT = S("Haiti"),
  HU = S("Hungary"),
  ID = S("Indonesia"),
  IE = S("Ireland"),
  IL = S("Israel"),
  IM = S("Isle of Man"),
  IN = S("India"),
  IO = S("British Indian Ocean Territory"),
  IQ = S("Iraq"),
  IR = S("Iran"),
  IS = S("Iceland"),
  IT = S("Italy"),
  JE = S("Jersey"),
  JM = S("Jamaica"),
  JO = S("Jordan"),
  JP = S("Japan"),
  KE = S("Kenya"),
  KG = S("Kyrgyzstan"),
  KH = S("Cambodia"),
  KI = S("Kiribati"),
  KM = S("Comoros"),
  KN = S("Saint Kitts and Nevis"),
  KP = S("North Korea"),
  KR = S("South Korea"),
  KW = S("Kuwait"),
  KY = S("Cayman Islands"),
  KZ = S("Kazakhstan"),
  LA = S("Lao"),
  LB = S("Lebanon"),
  LC = S("Saint Lucia"),
  LI = S("Liechtenstein"),
  LK = S("Sri Lanka"),
  LR = S("Liberia"),
  LS = S("Lesotho"),
  LT = S("Lithuania"),
  LU = S("Luxembourg"),
  LV = S("Latvia"),
  LY = S("Libya"),
  MA = S("Morocco"),
  MC = S("Monaco"),
  MD = S("Moldova"),
  ME = S("Montenegro"),
  MF = S("Saint Martin"),
  MG = S("Madagascar"),
  MH = S("Marshall Islands"),
  MK = S("North Macedonia"),
  ML = S("Mali"),
  MM = S("Myanmar"),
  MN = S("Mongolia"),
  MO = S("Macao"),
  MP = S("Northen Mariana Islands"),
  MQ = S("Martinique"),
  MR = S("Mauritania"),
  MS = S("Montserrat"),
  MT = S("Malta"),
  MU = S("Mauritius"),
  MV = S("Maldives"),
  MW = S("Malawi"),
  MX = S("Mexico"),
  MY = S("Malaysia"),
  MZ = S("Mozambique"),
  NA = S("Namibia"),
  NC = S("New Caledonia"),
  NE = S("Niger"),
  NF = S("Norfolk Island"),
  NG = S("Nigeria"),
  NI = S("Nicaragua"),
  NL = S("Netherlands"),
  NO = S("Norway"),
  NP = S("Nepal"),
  NR = S("Nauru"),
  NU = S("Niue"),
  NZ = S("New Zealand"),
  OM = S("Oman"),
  PA = S("Panama"),
  PE = S("Peru"),
  PF = S("French Polynesia"),
  PG = S("Papua New Guinea"),
  PH = S("Philippines"),
  PK = S("Pakistan"),
  PL = S("Poland"),
  PM = S("Saint Pierre and Miquelon"),
  PN = S("Pitcairn"),
  PR = S("Puerto Rico"),
  PS = S("Palestine"),
  PT = S("Portugal"),
  PW = S("Palau"),
  PY = S("Paraguay"),
  QA = S("Qatar"),
  RE = S("Réunion"),
  RO = S("Romania"),
  RS = S("Serbia"),
  RU = S("Russia"),
  RW = S("Rwanda"),
  SA = S("Saudi Arabia"),
  SB = S("Solomon Islands"),
  SC = S("Seychelles"),
  SD = S("Sudan"),
  SE = S("Sweden"),
  SG = S("Singapore"),
  SH = S("Saint Helena, Ascension and Tristan da Cunha"),
  SI = S("Slovenia"),
  SJ = S("Svalbard and Jan Mayen"),
  SK = S("Slovakia"),
  SL = S("Sierra Leone"),
  SM = S("San Marino"),
  SN = S("Senegal"),
  SO = S("Somalia"),
  SR = S("Suriname"),
  SS = S("South Sudan"),
  ST = S("Sao Tome and Principe"),
  SV = S("El Salvador"),
  SX = S("Sint Maarten"),
  SY = S("Syria"),
  SZ = S("Eswatini"),
  TC = S("Turks and Caicos Islands"),
  TD = S("Chad"),
  TF = S("French Southern Territories"),
  TG = S("Togo"),
  TH = S("Thailand"),
  TJ = S("Tajikistan"),
  TK = S("Tokelau"),
  TL = S("Timor-Leste"),
  TM = S("Turkmenistan"),
  TN = S("Tunisia"),
  TO = S("Tonga"),
  TR = S("Turkey"),
  TT = S("Trinidad and Tobago"),
  TV = S("Tuvalu"),
  TW = S("Taiwan"),
  TZ = S("Tanzania"),
  UA = S("Ukraine"),
  UG = S("Uganda"),
  UM = S("United States Minor Outlying Islands"),
  US = S("United States of America"),
  UY = S("Uruguay"),
  UZ = S("Uzbekistan"),
  VA = S("Holy See"),
  VC = S("Saint Vincent and the Grenadines"),
  VE = S("Venezuela"),
  VG = S("Virgin Islands (British)"),
  VI = S("Virgin Islands (U.S.A.)"),
  VN = S("Viet Nam"),
  VU = S("Vanuatu"),
  WF = S("Wallis and Futuna"),
  WS = S("Samoa"),
  YE = S("Yemen"),
  YT = S("Mayotte"),
  ZA = S("South Africa"),
  ZM = S("Zambia"),
  ZW = S("Zimbabwe")
}



function country_lib.get_countries()
  return table.copy(COUNTRIES)
end



function country_lib.get_country_codes()
  return table.copy(COUNTRY_CODES_TBL)
end



function country_lib.get_country_name(code)
  return COUNTRIES[code] or S("Unknown")
end



function country_lib.get_country_flag(code)
  return "countrylib_" .. (COUNTRIES[code] and string.lower(code) or "---") .. ".png"
end