magic_compass.items = {}

local yaml = dofile(minetest.get_modpath("magic_compass") .. "/src/yaml_parser.lua")
local S = minetest.get_translator("magic_compass")




local function load_locations()

  local wrld_dir = minetest.get_worldpath() .. "/magic_compass"
  local content = minetest.get_dir_list(wrld_dir)

  local modpath = minetest.get_modpath("magic_compass")
  local i18n_dir = modpath .. "/locale/locations"
  local txtr_dir = modpath .. "/textures/locations"
  local menu_ui_dir = modpath .. "/textures/menu"


  -- se la cartella delle skin non esiste/è vuota, copio la cartella base `IGNOREME`
  if not next(content) then
    local src_dir = minetest.get_modpath("magic_compass") .. "/IGNOREME"
    minetest.cpdir(src_dir, wrld_dir)
    minetest.cpdir(src_dir .. "/locale", i18n_dir)
    minetest.cpdir(src_dir .. "/icons", txtr_dir)
    minetest.cpdir(src_dir .. "/menu", menu_ui_dir)
    os.remove(wrld_dir .. "/README.md")
    content = minetest.get_dir_list(wrld_dir)
  else
    minetest.cpdir(wrld_dir .. "/locale", i18n_dir)
    minetest.cpdir(wrld_dir .. "/icons", txtr_dir)
    minetest.cpdir(wrld_dir .. "/menu", menu_ui_dir)
  end


  for _, f_name in pairs(content) do
    -- carica le posizioni
    if f_name:sub(-4) == ".yml" or f_name:sub(-5) == ".yaml" then
      local file = io.open(wrld_dir .. "/" .. f_name, "r")
      local locs = yaml.parse(file:read("*all"))

      for ID, loc in pairs(locs) do

        assert(type(ID) == "number",  "[MAGIC_COMPASS] Invalid location ID '" .. ID .. "': numbers only!")
        assert(loc.description,       "[MAGIC_COMPASS] Location #" .. ID .. " has no description!")
        assert(loc.icon,              "[MAGIC_COMPASS] Location #" .. ID .. " has no icon!")
        assert(loc.teleport_to,       "[MAGIC_COMPASS] Location #" .. ID .. " has no teleport coordinates!")

        minetest.register_tool("magic_compass:" .. ID, {
          description = S(loc.description),
          inventory_image = loc.icon,
          groups = {not_in_creative_inventory = 1, oddly_breakable_by_hand = 2}
        })

        magic_compass.items[ID] = {desc = loc.description, pos = loc.teleport_to, cooldown = loc.cooldown, privs = loc.requires, hide = loc.hidden_by_default}
      end

      file:close()
    end
  end
end

load_locations()
