function magic_compass.get_formspec()

  local SLOTS_PER_ROW = 5
  local rows = math.floor(#magic_compass.items / SLOTS_PER_ROW) + 1

  local formspec = {
    "size[6," .. 1.5 + (rows-1) .. "]"
  }

  -- aggiungo i vari slot (matrice i*j)
  for i = 1, rows do
    for j = 1, SLOTS_PER_ROW do

      local x = 0.5 + (j-1)
      local y = 0.33 + (i-1)
      local ID = i*j
      local item = magic_compass.items[ID]

      if item then
        table.insert(formspec, i+1, "item_image_button[" .. x .. "," .. y .. ";1,1;" .. item.name .. ";" .. ID .. ";]")
      else
        table.insert(formspec, i+1, "image_button[" .. x .. "," .. y .. ";1,1;;EMPTY;]")
      end
    end
  end

  return table.concat(formspec,"")
end
