magic_compass.items = {}

local locations_dir = minetest.get_modpath("magic_compass") .. "/locations"
local locations_content = minetest.get_dir_list(locations_dir)


for _, file_name in pairs(locations_content) do

  -- estrapolo le info dal file
  local file = io.open(locations_dir .. "/" .. file_name, "r")
  local data = string.split(file:read("*all"), "\n")

  file:close()

  local i_name = data[1]
  local i_texture = data[2]
  local i_pos = data[3]

  -- creo l'oggetto
  minetest.register_tool("magic_compass:" .. i_name, {

    description = i_name,
    inventory_image = i_texture,
    groups = {not_in_creative_inventory = 1, oddly_breakable_by_hand = 2}

  })

  table.insert(magic_compass.items, {name ="magic_compass:" .. i_name, pos = i_pos})

end
