function magic_compass.get_formspec(p_name)

  local SLOTS_PER_ROW = 5
  local rows = math.floor(table.maxn(magic_compass.items) / SLOTS_PER_ROW - 0.1) + 1

  local formspec = {
    "size[6," .. 1.5 + (rows-1) .. "]"
  }

  -- aggiungo i vari slot (matrice i*j)
  for i = 1, rows do
    for j = 1, SLOTS_PER_ROW do

      local x = 0.5 + (j-1)
      local y = 0.33 + (i-1)
      local ID = SLOTS_PER_ROW * (i-1) + j
      local item = magic_compass.items[ID]

      if item then
        if item.privs then
          if not item.hide or (item.hide and minetest.check_player_privs(p_name, minetest.string_to_privs(item.privs, ", "))) then
            table.insert(formspec, i+1, "item_image_button[" .. x .. "," .. y .. ";1,1;magic_compass:" .. ID .. ";" .. ID .. ";]")
          else
            table.insert(formspec, i+1, "image_button[" .. x .. "," .. y .. ";1,1;;EMPTY;]")
          end
        else
          table.insert(formspec, i+1, "item_image_button[" .. x .. "," .. y .. ";1,1;magic_compass:" .. ID .. ";" .. ID .. ";]")
        end
      else
        table.insert(formspec, i+1, "image_button[" .. x .. "," .. y .. ";1,1;;EMPTY;]")
      end
    end
  end

  return table.concat(formspec,"")
end
