panel_lib.panels = {}       -- KEY: p_name; VALUE: {{"panel name" = panel}, {"panel name 2" = panel2}, ...}

local function clone_table() end

Panel = {
    name = "",
    -- player to show the panel to
    player_name = "",
    -- ids of the hud of the player
    hud_id = {},
    -- because the panel is composed by a background and a text we need to
    -- define the two HUD to use later
    background_def = {
        hud_elem_type = "image",
        position = { x = 1, y = 0.5 },
        scale = { x = 1, y = 1 },
        alignment = { x = -1, y = 0 },
        text = "panel_bg.png",
    },
    title_def = {
        hud_elem_type = "text",
        position  = {x = 1, y = 0.5},
        alignment = {x = 0, y = 0},
        offset    = {x = 0, y = 0},
        size      = { x = 1 },
        number    = 0xFFFFFF,
        text      = "Default"
    },

    sub_img_elems = {},
    sub_txt_elems = {},

    is_shown = false

}



function Panel:new(def)
    local panel = {}
    local metapanel = clone_table(Panel)

    setmetatable(panel, metapanel)
    metapanel.__index = metapanel

    if not def.name or type(def.name) ~= "string" then
      minetest.log("warning", "[PANEL_LIB] Can't create a panel without a proper name, aborting")
      return
    else
      panel.name = def.name
    end

    if def.position then
      panel.background_def.position = def.position
      panel.title_def.position = def.position
    end

    if def.alignment then
      panel.background_def.alignment = def.alignment
    end

    if def.bg then
      panel.background_def.text = def.bg
    end

    if def.bg_scale then
      panel.background_def.scale = def.bg_scale
    end

    if def.title then
      panel.title_def.text = def.title
    end

    if def.title_alignment then
      panel.title_def.alignment = def.title_alignment
    end

    if def.title_offset then
      panel.title_def.offset = def.title_offset
    end

    if def.title_color then
      panel.title_def.number = def.title_color
    end

    if def.title_size then
      panel.title_def.size = def.title_size
    end

    if def.player then
      panel.player_name = def.player
    end

    -- controllo sottoelementi
    if def.sub_img_elems then
      local i = 1
      for name, elem in pairs(def.sub_img_elems) do
        panel.sub_img_elems[i] = name
        panel[name] = clone_table(panel.background_def)

        for param, v in pairs(elem) do
          panel[name][param] = v
        end

        -- mantengo la stessa posizione del corpo del panel, costringendo
        -- l'utente a modificare gli offset se vuole spostare gli elementi
        panel[name].position = def.position
        i = i +1
      end
    end

    if def.sub_txt_elems then
      local i = 1
      for name, elem in pairs(def.sub_txt_elems) do
        panel.sub_txt_elems[i] = name
        panel[name] = clone_table(panel.title_def)

        for param, v in pairs(elem) do
          panel[name][param] = v
        end

        -- idem come sopra
        panel[name].position = def.position
        i = i +1
      end
    end

    -- salvo in memoria
    if not panel_lib.panels[def.player] then
      panel_lib.panels[def.player] = {}
    end

    panel_lib.panels[def.player][def.name] = panel
    return panel
end



function Panel:show()
	local player = minetest.get_player_by_name(self.player_name)
	self.hud_id.bg_hud_id = player:hud_add(self.background_def)
	self.hud_id.text_hud_id = player:hud_add(self.title_def)

  --check for custom elements
  for _, name in pairs(self.sub_img_elems) do
    self.hud_id[name] = player:hud_add(self[name])
  end

  for _, name in pairs(self.sub_txt_elems) do
    self.hud_id[name] = player:hud_add(self[name])
  end

  self.is_shown = true
end



function Panel:hide()

  if (self.hud_id) then
    local player = minetest.get_player_by_name(self.player_name)

    for k, v in pairs(self.hud_id) do
      player:hud_remove(self.hud_id[k])
    end
	end

  self.is_shown = false
end



function Panel:update(def, txt_elems, img_elems)

  local player = minetest.get_player_by_name(self.player_name)

  if def ~= nil then
    for k, v in pairs(def) do
      self[k] = v
    end
  end

  if txt_elems ~= nil then

    for elem, _ in pairs(txt_elems) do
      for k, v in pairs(txt_elems[elem]) do
        self[elem][k] = v
        if self.is_shown == true then
          player:hud_change(self.hud_id[elem], k, v)
        end
      end
    end

  end

  if img_elems ~= nil then

    for elem, _ in pairs(img_elems) do
      for k, v in pairs(img_elems[elem]) do
        self[elem][k] = v
        if self.is_shown == true then
          player:hud_change(self.hud_id[elem], k, v)
        end
      end
    end

  end
end



function Panel:remove()
  panel_lib.panels[self.player_name][self.name] = nil
  self:hide()
  self = nil
end



function Panel:is_shown()
  if self.is_shown then return true
  else return false end
end





----------------------------------------------
-----------------GETTERS----------------------
----------------------------------------------

function panel_lib.get_panel(p_name, panel_name)
  return panel_lib.panels[p_name][panel_name]
end





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

-- code from => http://lua-users.org/wiki/CopyTable
function clone_table(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == 'table' then
        copy = {}
        for orig_key, orig_value in pairs(orig) do
            copy[clone_table(orig_key)] = clone_table(orig_value)
        end
        setmetatable(copy, clone_table(getmetatable(orig)))
    else -- number, string, boolean, etc
        copy = orig
    end
    return copy
end
