# Parties docs

Because it's always good to understand the API without surfing the code, init? :D

## 1 API

### 1.1 Utils

* `parties.is_player_in_party(p_name)`: (bool) checks whether a player is in any party
* `parties.is_player_party_leader(p_name)`: (bool) checks whether a player is the party leader of any party
* `parties.chat_send_party(p_name, msg, as_broadcast)`: (nil) sends a message to every player inside the party where `p_name` is (`p_name` doesn't necessarily have to be the party leader). If `as_broadcast` is true, it'd be sent without following Minetest chat format. If false, `p_name` will be pointed as the sender when formatting the message
* `parties.change_party_leader(old_leader, new_leader)`: (nil) changes the party leader

### 1.2 Getters

* `parties.get_party_leader(p_name)`: (string) returns the party leader of the party where `p_name` is in
* `parties.get_party_members(party_leader)`: (table) returns a list of every player inside the party of `party_leader`

## 2 Customisation

### 2.1 Chat

Chat is light blue by default and it adds the `[Party] ` prefix at the beginning of every message. It then follows the format of the chat set by the owner. By default is:  
`[Party] <playername> message`


