parties = {}

local function format_party_message() end

local S = minetest.get_translator("parties")
local current_parties = {}                  -- KEY party_leader; VALUE: {members (party_leader included)}
local players_in_parties = {}               -- KEY p_name; VALUE: party_leader
local players_invited = {}                  -- KEY p_name; VALUE: inviter





function parties.invite(sender, p_name)

  -- se si è in un gruppo ma non si è il capo gruppo
  if players_in_parties[sender] and not current_parties[sender] then
    minetest.chat_send_player(sender, minetest.colorize("#e6482e", S("[!] Only the party leader can perform this action!")))
    return end

  -- se si invita se stessi
  if sender == p_name then
    minetest.chat_send_player(sender, minetest.colorize("#e6482e", S("[!] You can't invite yourself!")))
    return end

  -- se il giocatore non è online
  if not minetest.get_player_by_name(p_name) then
    minetest.chat_send_player(sender, minetest.colorize("#e6482e", S("[!] This player is not online!")))
    return end

  -- se è già stato invitato dalla stessa persona
  if players_invited[p_name] and players_invited[p_name] == sender then
    minetest.chat_send_player(sender, minetest.colorize("#e6482e", S("[!] You've already invited this player!")))
    return end

  -- se è già in un gruppo
  if players_in_parties[p_name] then
    minetest.chat_send_player(sender, minetest.colorize("#e6482e", S("[!] This player is already in a party!")))
    return end

  -- se non può essere invitato (callback)
  for _, callback in ipairs(parties.registered_on_pre_party_invite) do
    if not callback(sender, p_name) then return end
  end

  -- TODO: riproduzione suono invito

  minetest.chat_send_player(sender, format_party_message(S("Invite to @1 successfully sent", p_name)))
  minetest.chat_send_player(p_name, format_party_message(S("@1 has invitied you in a party, would you like to join? (/party join)", sender)))
  players_invited[p_name] = sender

  -- eventuali callback
  for _, callback in ipairs(parties.registered_on_party_invite) do
    callback(sender, p_name)
  end

  -- se non ha accettato dopo 15 secondi, annullo l'invito
  minetest.after(15, function()
    if players_invited[p_name] and players_invited[p_name] == sender then
      players_invited[p_name] = nil
      if minetest.get_player_by_name(sender) then
        minetest.chat_send_player(sender, format_party_message(minetest.colorize("#ededed", S("No answer from @1...", p_name))))
      end
    end
  end)
end



function parties.join(p_name)

  -- se non ha nesssun invito
  if not players_invited[p_name] then
    minetest.chat_send_player(p_name, minetest.colorize("#e6482e", S("[!] You have no pending invites!")))
    return end

  local party_leader = players_invited[p_name]

  -- se il capo gruppo si è disconnesso nei 15 secondi
  if not minetest.get_player_by_name(party_leader) then
    minetest.chat_send_player(p_name, minetest.colorize("#e6482e", S("[!] The party leader has disconnected!")))
    players_invited[p_name] = nil
    return end

  -- se non può accettare (callback)
  for _, callback in ipairs(parties.registered_on_pre_party_join) do
    if not callback(party_leader, p_name) then return end
  end

  if players_in_parties[party_leader] == nil then
    current_parties[party_leader] = {party_leader}
    players_in_parties[party_leader] = party_leader
  end

  parties.chat_send_party(party_leader, S("@1 has joined the party", p_name), true)

  players_invited[p_name] = nil
  players_in_parties[p_name] = party_leader

  table.insert(current_parties[party_leader], p_name)
  minetest.chat_send_player(p_name, format_party_message(S("You've joined @1's party", party_leader)))

  -- eventuali callback
  for _, callback in ipairs(parties.registered_on_party_join) do
    callback(party_leader, p_name)
  end

end



function parties.leave(p_name)

  -- se non si è in un gruppo
  if not players_in_parties[p_name] then
    minetest.chat_send_player(p_name, minetest.colorize("#e6482e", S("[!] You must enter a party first!")))
    return end

  -- se si aveva invitato qualcuno

  local party_leader = players_in_parties[p_name]

  -- rimuovo dal gruppo
  for k, pl_name in pairs(current_parties[party_leader]) do
    if pl_name == p_name then
      table.remove(current_parties[party_leader], k)
      break
    end
  end

  players_in_parties[p_name] = nil
  minetest.chat_send_player(p_name, format_party_message(S("You've left the party")), true)

  -- eventuali callback
  for _, callback in ipairs(parties.registered_on_party_leave) do
    callback(party_leader, p_name)
  end

  -- se ad abbandonare è stato il capo gruppo, lo cambio
  if p_name == party_leader then

    local new_leader = current_parties[party_leader][1]

    parties.chat_send_party(new_leader, S("@1 has left the party", p_name), true)
    parties.change_party_leader(p_name, new_leader)

    -- ...sciolgo se sono rimasti in 2
    if #current_parties[new_leader] == 1 then
      parties.disband(new_leader)
    end

  else
    parties.chat_send_party(party_leader, S("@1 has left the party", p_name), true)

    if #current_parties[party_leader] == 1 then
      parties.disband(party_leader)
    end
  end

end



function parties.disband(p_name)

  -- se non si è in un gruppo
  if not players_in_parties[p_name] then
    minetest.chat_send_player(p_name, minetest.colorize("#e6482e", S("[!] You must enter a party first!")))
    return end

  -- se si è in un gruppo ma non si è il capo gruppo
  if players_in_parties[p_name] and not current_parties[p_name] then
    minetest.chat_send_player(p_name, minetest.colorize("#e6482e", S("[!] Only the party leader can perform this action!")))
    return end

  parties.chat_send_party(p_name, S("The party has been disbanded"), true)

  -- eventuali callback
  for _, callback in ipairs(parties.registered_on_party_disband) do
    callback(p_name)
  end

  for _, pl_name in pairs(current_parties[p_name]) do
    players_in_parties[pl_name] = nil
  end

  current_parties[p_name] = nil
end





----------------------------------------------
--------------------UTILS---------------------
----------------------------------------------

function parties.is_player_invited(p_name)
  if players_invited[p_name] then return true
  else return false end
end



function parties.is_player_in_party(p_name)
  if players_in_parties[p_name] then return true
  else return false end
end



function parties.is_player_party_leader(p_name)
  if current_parties[p_name] then return true
  else return false end
end



function parties.chat_send_party(p_name, msg, as_broadcast)

  if not players_in_parties[p_name] then
    minetest.chat_send_player(p_name, minetest.colorize("#e6482e", S("[!] You must enter a party first!")))
    return end

  local party_leader = players_in_parties[p_name]

  if as_broadcast then
    for _, pl_name in pairs(current_parties[party_leader]) do
      minetest.chat_send_player(pl_name, format_party_message(msg))
    end
  else
    for _, pl_name in pairs(current_parties[party_leader]) do
      minetest.chat_send_player(pl_name,  format_party_message(minetest.format_chat_message(p_name, msg)))
    end
  end

end



function parties.change_party_leader(old_leader, new_leader)

  current_parties[new_leader] = {}

  for k, v in pairs(current_parties[old_leader]) do
    current_parties[new_leader][k] = v
    players_in_parties[v] = new_leader
  end

  current_parties[old_leader] = nil

  if #current_parties[new_leader] > 1 then
    parties.chat_send_party(new_leader, S("@1 is the new party leader", new_leader), true)
  end

end



function parties.cancel_invite(p_name)
 players_invited[p_name] = nil
end




----------------------------------------------
-----------------GETTERS----------------------
----------------------------------------------

function parties.get_inviter(p_name)
  return players_invited[p_name]
end



function parties.get_party_leader(p_name)
  return players_in_parties[p_name]
end



function parties.get_party_members(party_leader)
  return current_parties[party_leader]
end





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function format_party_message(msg)
  return minetest.colorize("#ddffdd", "[" .. S("Party") .. "] " .. msg)
end
