function weapons_lib.is_in_the_air(obj_ref)
  local obj_pos = obj_ref:get_pos()
  local node_beneath = vector.new(obj_pos.x, obj_pos.y - 0.4, obj_pos.z)
  local is_in_the_air = minetest.get_node(node_beneath).name == "air"

  return is_in_the_air
end



local sound_handles = {}
local IS_AUDIO_LIB = minetest.get_modpath("audio_lib")


function weapons_lib.play_sound(sound, p_name, save_handle)
  if IS_AUDIO_LIB and audio_lib.is_sound_registered(sound) then
    --audio_lib.play_sound(sound, {object = minetest.get_player_by_name(p_name)})
    audio_lib.play_sound(sound, {to_player = p_name})
  else
    sound_handles[sound .. "@" .. p_name] = minetest.sound_play(sound, {to_player = p_name})
  end
end



function weapons_lib.stop_sound(sound, p_name)
  if IS_AUDIO_LIB and audio_lib.is_sound_registered(sound) then
    audio_lib.stop_sound(p_name, sound)
  else
    minetest.sound_stop(sound_handles[sound .. "@" .. p_name])
  end
end