--[[
	Lag Compensation System - Shared Constants and Data.
]]

weapons_lib.lagcomp = weapons_lib.lagcomp or {}

weapons_lib.lagcomp.LAG_COMP_ENABLED = weapons_lib.settings.LAG_COMPENSATION_ENABLED
weapons_lib.lagcomp.HISTORY_DURATION = 1

weapons_lib.lagcomp.DEFAULT_EYE_HEIGHT = 1.475
weapons_lib.lagcomp.DEFAULT_COLLISIONBOX = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3}

-- Use linear interpolation for recent data (<300ms snapshots)
weapons_lib.lagcomp.RECENT_INTERPOLATION_THRESHOLD = 0.3

-- Stores the position history for all tracked players
-- Structure: { player_name = { {time=t, pos={x,y,z}, velocity={x,y,z}}, ... } }
weapons_lib.lagcomp.player_history = {}

-- Debug simulation data
-- Structure: { player_name = { ping = simulated_ping } }
weapons_lib.lagcomp.debug_simulation = {}

-- Debug mode tracking (cached in RAM for performance)
-- Structure: { player_name = true/false }
weapons_lib.lagcomp.debug_mode_cache = {}

-- Debug simulated server step (in seconds)
weapons_lib.lagcomp.debug_simulated_step = 0
weapons_lib.lagcomp.last_snapshot_time = 0

-- Artificial movement system data
-- Structure: { player_name = { active = bool, direction = 1 or -1, push_count = number, timer = timer } }
weapons_lib.lagcomp.artificial_movement = {}

-- Stress test status
weapons_lib.lagcomp.debug_stress_test_active = false
