local S = core.get_translator("weapons_lib")



-- Test command to control lag compensation debug output
core.register_chatcommand("lagcomp_debug", {
    params = "on|off|status",
    description = S("Control lag compensation debug output"),
    privs = {debug = true},
    func = function(name, param)
        local player = core.get_player_by_name(name)
        if not player then return false, S("Player not found") end

        if param == "on" then
            weapons_lib.lagcomp.debug_set_mode(player, true)
            return true, S("Debug output ENABLED")
        elseif param == "off" then
            weapons_lib.lagcomp.debug_set_mode(player, false)
            return true, S("Debug output DISABLED")
        elseif param == "status" then
            local lag_enabled = weapons_lib.settings.LAG_COMPENSATION_ENABLED
            local debug_enabled = weapons_lib.lagcomp.debug_get_mode(player)
            local player_info = core.get_player_information(name)
            local ping = player_info and player_info.avg_rtt and (player_info.avg_rtt * 1000) or "unknown"

            return true, S("Lag compensation: @1 | Debug: @2 | Ping: @3 ms",
                lag_enabled and S("ON") or S("OFF"),
                debug_enabled and S("ON") or S("OFF"),
                tostring(ping)
            )
        else
            return false, S("Usage: /lagcomp_debug on|off|status")
        end
    end,
})



-- Debug command for lag simulation (local testing)
core.register_chatcommand("lagcomp_simulate", {
    params = "<target_player> <shooter_player> <ping_ms>",
    description = S("Setup lag simulation (ping 0 to disable)"),
    privs = {debug = true},
    func = function(name, param)
        local target_player, shooter_player, ping_str = param:match("^(%S+)%s+(%S+)%s+(%d+)$")

        if not target_player or not shooter_player or not ping_str then
            return false, S("Usage: /lagcomp_simulate <target> <shooter> <ping_ms>")
        end

        local ping_ms = tonumber(ping_str)
        if not ping_ms or ping_ms < 0 or ping_ms > 1000 then
            return false, S("Ping must be 0-1000ms")
        end

        if not weapons_lib.settings.LAG_COMPENSATION_ENABLED then
            return false, S("Lag compensation disabled in SETTINGS.lua")
        end

        if ping_ms == 0 then
            -- Disable simulation
            weapons_lib.lagcomp.debug_set_simulated_ping(shooter_player, 0)
            local target = core.get_player_by_name(target_player)
            local shooter = core.get_player_by_name(shooter_player)

            if target and weapons_lib.lagcomp.debug_set_artificial_movement then
                weapons_lib.lagcomp.debug_set_artificial_movement(target, false)
            end

            if shooter then
                weapons_lib.lagcomp.debug_set_mode(shooter, false)
            end

            return true, S("Simulation disabled for @1/@2", target_player, shooter_player)
        else
            -- Enable simulation
            local success1 = weapons_lib.lagcomp.debug_set_simulated_ping(shooter_player, ping_ms)
            local target = core.get_player_by_name(target_player)
            local shooter = core.get_player_by_name(shooter_player)
            local success2 = false

            if target and weapons_lib.lagcomp.debug_set_artificial_movement then
                success2 = weapons_lib.lagcomp.debug_set_artificial_movement(target, true)
            end

            if shooter then
                weapons_lib.lagcomp.debug_set_mode(shooter, true)
            end


            if success1 and success2 then
                return true, S("Simulation: @1(target) @2(shooter) @3ms",
                    target_player, shooter_player, ping_ms)
            else
                return false, S("Setup failed")
            end
        end
    end,
})



core.register_chatcommand("lagcomp_stress_test", {
    params = "on/off",
    description = S("Test lag compensation system"),
    privs = {debug = true},
    func = function(name, param)
        if not weapons_lib.settings.LAG_COMPENSATION_ENABLED then
            return false, S("Lag compensation must be enabled for stress testing")
        end

        if param == "on" then
            if weapons_lib.lagcomp.debug_stress_test_active then
                return false, S("Stress test is already running")
            end

            -- Generate simulated players and activate stress test
            weapons_lib.lagcomp.debug_generate_stress_players()
            weapons_lib.lagcomp.debug_stress_test_active = true

            return true, S("Stress test STARTED")
        elseif param == "off" then
            if not weapons_lib.lagcomp.debug_stress_test_active then
                return false, S("Stress test is not running")
            end

            -- Clean up stress test
            weapons_lib.lagcomp.debug_cleanup_stress_test()

            return true, S("Stress test STOPPED. Simulated player data cleaned up.")
        else
            return false, S("Usage: /lagcomp_stress_test on/off")
        end
    end,
})
