weapons_lib.register_weapon("weapons_lib:test_lagcomp", {
    description = "Lag Compensation Test Weapon\n\n" ..
        "Tests lag compensation with visual debug indicators.\n" ..
        "Magazine: 5 bullets, Reload: 2s\n\n" ..
        "Setup:\n" ..
        "1. '/lagcomp_debug on' - enable debug output\n" ..
        "2. '/lagcomp_simulate <target> <shooter> <ping>' - automated testing\n\n" ..
        "Visual indicators:\n" ..
        "• Black/white particles = raw position\n" ..
        "• Red particles = interpolated position (used for hits)",

    wield_scale = {x = 1.2, y = 1.2, z = 1.2},
    wield_image = "weaponslib_test1_sprite.png",
    inventory_image = "weaponslib_test1_sprite.png",

    weapon_type = "ranged",
    magazine = 5,
    reload_time = 2,
    sound_reload = "weaponslib_test1_reload",
    crosshair = "weaponslib_test2_crosshair.png",

    action1 = {
        type = "raycast",
        damage = 6,
        range = 40,
        delay = 0.4,
        sound = "weaponslib_test1_attack",
        trail = {
            image = "weaponslib_test1_trail2.png",
            size = 2.5,
            life = 0.5
        }
    },

    can_use_weapon = function(player, action)
        local p_name = player:get_player_name()
        if action and action.type == "raycast" then
            local comp_enabled = weapons_lib.settings.LAG_COMPENSATION_ENABLED
            local status = comp_enabled and "ENABLED" or "DISABLED"

            core.chat_send_player(p_name,
                "Lag compensation " .. status .. " | Use '/lagcomp_debug on' for detailed info")
        end
        return true
    end
})
