local EDITABLE_NODES = table.key_value_swap(class_palette.PALETTE)

for _, node in pairs(class_palette.PALETTE_UNLISTED) do
  EDITABLE_NODES[node] = true
end

local old_is_protected = core.is_protected

function core.is_protected(pos, name)
  local node_name_at_pos = core.get_node(pos).name

  if core.check_player_privs(name, "teacher") or node_name_at_pos == "air" or EDITABLE_NODES[node_name_at_pos] then
    return old_is_protected(pos, name)
  else
    return true
  end
end