core.register_on_joinplayer(function(player, last_login)
  if core.check_player_privs(player, "teacher") then return end

  local palette_size = #class_palette.PALETTE
  local p_inv = player:get_inventory()

  player:set_inventory_formspec("")
  player:hud_set_hotbar_itemcount(palette_size)

  -- sennò quella di `default` può venire impostata dopo e sovrascriverla
  core.after(0.1, function()
    player:hud_set_hotbar_image("classroom_hotbar" .. palette_size .. ".png")
  end)

  for i, node in ipairs(class_palette.PALETTE) do
    p_inv:set_stack("main", i, node)
  end
end)



local old_item_drop = core.item_drop

function core.item_drop(itemstack, dropper, pos)
  if not core.is_player(dropper) or core.check_player_privs(dropper, "teacher") then
    return old_item_drop(itemstack, dropper, pos)
  else
    return
  end
end