local color = minetest.colorize

local ITEMS = {
{"white_loofah", "White Loofah", "loofah", 80, 200},
{"floral_bodysoap", color("#FFE0DD", "Floral").." Bodysoap", "bodysoap", 0, 0},
{"toothbrush", "Toothbrush", "toothbrush", 15, 115},
{"wooden_toothbrush", color("#ffd7b6", "Wooden").." Toothbrush", "toothbrush", 15, 110},
{"coco_toothpaste", color("#89675a", "Coconut").." Toothpaste\n whitening\n strengthening\n "..color("#FFCECF", "sensitive"), "toothpaste", 0, 0},
{"rosewater_condish", "Natural Conditioner\n"..color("#ffbcc6", "rosewater extracts"), "condish", 14, 17},
{"rosemary_shampoo", color("#ff95af", "Rosemary").." Shampoo\n hair growth", "shampoo", 30, 17}, 
{"egg_hairmask", color("#ffb359", "Egg").." Hairmask", "hairmask", 30, 2},
{"oat_facesoap", "Face Soap\n"..color("#dfbda1", "Oat Extracts"), "facesoap", 30, 15},
{"heartleaf_moisturiser", color("#ffdcf3", "Heartleaf").." Face Cream", "moisturizer", 20, 19},
{"pimplepatch", "5 "..color("#ffdad8", "Pimple").." Patches", "pimpatch", 0, 4},
}

for i in ipairs(ITEMS) do
  local name = ITEMS[i][1]
  local desc = ITEMS[i][2]
  local type = ITEMS[i][3]
  local c    = ITEMS[i][4]
  local uses = ITEMS[i][5]

selfcare.add_product("self_care:"..name, {
    description = desc,
    inventory_image = "selfcare_"..name..".png",
    on_use = function(itemstack, user, pointed_thing)
      local u = user:get_player_name()

	if type == "loofah" then
	    selfcare.func.Loofah(itemstack, user, c, uses)
	elseif type == "mirror" then
	    selfcare.form.Hygiene(u)
	elseif type == "toothbrush" then
	    selfcare.func.Toothbrush(itemstack, user, c)
	elseif type == "shampoo" then
	    selfcare.effect.WashHair(user, c)
	elseif type == "condish" then
	    selfcare.effect.CondishHair(user, c, false)
	elseif type == "hairmask" then
	    selfcare.effect.CondishHair(user, c, true)
	elseif type == "perfume" then
	    selfcare.effect._(user, c, "spray", -0.6)
	elseif type == "facesoap" then
	    selfcare.effect.WashFace(user, c)
	elseif type == "moisturizer" then
	    selfcare.effect.CreamFace(user, c)
	elseif type == "pimpatch" then
	  if selfcare.get(user, "pimpatch") ~= "yes" then
	    selfcare.set(user, "pimpatch", "yes")
	    selfcare.set(user, "pimpatch_t", "0")
	  end
	end
	itemstack:add_wear(65535 / uses)
	return itemstack
    end
})
end

--	[ misc ]

selfcare.add_item("self_care:cottonpad", {
    description = "Cottonpad",
    inventory_image = "selfcare_cottonpad.png"
})

selfcare.add_item("self_care:coconut_oil", {
    description = "Bottle of Coconut Oil",
    inventory_image = "selfcare_coconut_oil.png"
})

selfcare.add_block("self_care:wooden_mirror", {
    description = "Wooden Mirror",
    inventory_image = "selfcare_mirror_wf.png",
    wield_image = "selfcare_mirror_wf.png",
    tiles = {	"default_aspen_wood.png",
		"default_aspen_wood.png",
		"default_aspen_wood.png",
		"default_aspen_wood.png",
		"default_aspen_wood.png",
		"selfcare_mirror_wf.png"
	    },
    paramtype = "light",
    paramtype2 = "facedir",
    drawtype = "nodebox",
    groups = { cracky = 2 },
    node_box = {
	type = "fixed",
	fixed = {
		{-0.19, -0.325, 0.5, 0.25, 0.435, 0.45},
		{-0.25, 0.435, 0.5, 0.25, 0.375, 0.435}, -- top
		{-0.25, -0.325, 0.5, 0.25, -0.275, 0.435}, -- bottom
		{-0.25, -0.325, 0.5, -0.19, 0.435, 0.435}, -- left
		{0.25, -0.325, 0.5, 0.19, 0.435, 0.435}, -- right
		}
    },
    on_rightclick = function(pos, node, clicker)
	selfcare.form.Hygiene(clicker:get_player_name())
    end
})