selfcare.effect = {}

local random = math.random

local function WashBody(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - 0.47
        
      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.1, y = pos.y + dir.y * 0.1 + eye, z = pos.z + dir.z * 0.1},
	time = 0.1,
	amount = 25,
	vel = {min = {x = -0.45, y = 1, z = -0.45}, max = {x = 0.45, y = 1.5, z = 0.45}},
	acc = {x = 0, y = -4, z = 0},
	size = {min = 2.5, max = 3.5},
	texture = "selfcare_bubble.png",
	collisiondetection = true,
	minexptime = 1,
	maxexptime = 1.5
})
end

local function WashHair(player)
    local pos = player:get_pos()
    local eye = player:get_properties().eye_height + 0.2
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + eye, z = pos.z},
	time = 0.1,
	amount = 20,
	vel = {min = {x = -0.7, y = 0.3, z = -0.7}, max = {x = 0.7, y = 0.55, z = 0.7}},
	acc = {x = 0, y = -2, z = 0},
	size = {min = 2, max = 3},
	texture = "selfcare_bubble.png",
	collisiondetection = true,
	minexptime = 0.7,
	maxexptime = 1.2
})
end

local function BrushTeeth(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - 0.1
        
      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.2, y = pos.y + dir.y * 0.2 + eye, z = pos.z + dir.z * 0.3},
	time = 0.1,
	amount = 25,
	vel = {min = {x = -0.2, y = 0.4, z = -0.2}, max = {x = 0.2, y = 0.4, z = 0.2}},
	acc = {x = 0, y = -1, z = 0},
	size = {min = 1, max = 1.5},
	texture = "selfcare_bubble.png^[multiply:#c8eced",
	collisiondetection = true,
	minexptime = 0.3,
	maxexptime = 0.5
})
end

local washface_txt = {"selfcare_bubble.png", "selfcare_bubble.png^[multiply:#fff4ed"}

local function WashFace(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height
        
      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.1, y = pos.y + dir.y * 0.2 + eye, z = pos.z + dir.z * 0.3},
	time = 0.1,
	amount = 20,
	vel = {min = {x = -0.2, y = 0.4, z = -0.2}, max = {x = 0.2, y = 0.4, z = 0.2}},
	acc = {x = 0, y = -1, z = 0},
	size = {min = 1, max = 1.5},
	texture = washface_txt[random(#washface_txt)],
	collisiondetection = true,
	minexptime = 1,
	maxexptime = 1.5
})
end

local function effect(player, type, height)
    local pos = player:get_pos()
    local offs = player:get_properties().eye_height + height

	if type == "cream" then
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + offs, z = pos.z},
	time = 0.1,
	amount = 7,
	vel = {min = {x = -0.7, y = 0.8, z = -0.7}, max = {x = 0.7, y = 1.2, z = 0.7}},
	acc = {x = 0, y = -4, z = 0},
	size = {min = 2, max = 3},
	texture = "selfcare_cream.png^[opacity:200",
	collisiondetection = true,
	minexptime = 0.3,
	maxexptime = 0.4
})
	elseif type == "spray" then
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + offs, z = pos.z},
	time = 0.1,
	amount = 11,
	vel = {min = {x = -0.7, y = 0.8, z = -0.7}, max = {x = 0.7, y = 1.2, z = 0.7}},
	acc = {x = 0, y = -4.8, z = 0},
	size = {min = 2.8, max = 3.8},
	texture = "selfcare_spray.png^[opacity:",
	collisiondetection = true,
	minexptime = 0.3,
	maxexptime = 0.5
})

	end
end

function selfcare.effect.WashBody(user, c)
    if c > 0 then
        WashBody(user)
        
        minetest.after(0.2, function()
            selfcare.effect.WashBody(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "smell", "clean")
	selfcare.set(user, "smell_t", "0")
	selfcare.set(user, "perfume", "aren't")
	selfcare.set(user, "perfume_t", "0")
    end
end

function selfcare.effect.CondishHair(user, c, deep_repair)

    local hair_condition = selfcare.get(user, "condish")

    if c > 0 then
        effect(user, "cream", 0.3)
        effect(user, "spray", 0.3)
        
        minetest.after(0.2, function()
            selfcare.effect.CondishHair(user, c - 1)
        end)
    elseif c <= 0 then

      if deep_repair then
	selfcare.set(user, "condish", "soft")
	selfcare.set(user, "condish_t", "0")

      else

	if hair_condition == "dry" then
	  selfcare.set(user, "condish", "soft")
	  selfcare.set(user, "condish_t", "0")
	end

      end

    end
end

function selfcare.effect.WashHair(user, c)
    if c > 0 then
        WashHair(user)
        
        minetest.after(0.2, function()
            selfcare.effect.WashHair(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "hair", "clean")
	selfcare.set(user, "hair_t", "0")
    end
end

function selfcare.effect.BrushTeeth(user, c)
    if c > 0 then
        BrushTeeth(user)
        
        minetest.after(0.2, function()
            selfcare.effect.BrushTeeth(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "teeth_t", "0")
	selfcare.set(user, "breath_t", "0")
	selfcare.set(user, "breath", "minty")
    end
end

function selfcare.effect.WashFace(user, c)
    if c > 0 then
        WashFace(user)
        
        minetest.after(0.2, function()
            selfcare.effect.WashFace(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "faceskin", "clean")
	selfcare.set(user, "faceskin_t", "0")
    end
end

function selfcare.effect._(user, c, type, height)
    if c > 0 then
	effect(user, type, height)

	minetest.after(0.2, function()
	    selfcare.effect._(user, c, type, height)
	end)
    elseif c <= 0 then
	selfcare.set(user, "perfume", "are")
	selfcare.set(user, "perfume_t", "0")
    end
end


local function CreamFace(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height + 0.1
        
      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.1, y = pos.y + dir.y * 0.2 + eye, z = pos.z + dir.z * 0.3},
	time = 0.1,
	amount = 20,
	vel = {min = {x = -0.2, y = 0.2, z = -0.2}, max = {x = 0.2, y = 0.2, z = 0.2}},
	acc = {min = {x = -0.2, y = -1, z = -0.2}, max = {x = 0.2, y = -1, z = 0.2}},
	size = {min = 1, max = 1.5},
	texture = "selfcare_spray.png",
	collisiondetection = true,
	minexptime = 0.5,
	maxexptime = 1
})
end

function selfcare.effect.CreamFace(user, c)
    if c > 0 then
        CreamFace(user)
        
        minetest.after(0.2, function()
            selfcare.effect.CreamFace(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "_faceskin", "soft")
	selfcare.set(user, "_faceskin_t", "0")
    end
end