local selfcare_timers = {}

local random = math.random
local tn = tonumber
local ts = tostring

selfcare.s_t = tonumber(minetest.settings:get("selfcare.smell_timer")) or 1800
selfcare.h_t = tonumber(minetest.settings:get("selfcare.hair_timer")) or 2400
selfcare.c_t = tonumber(minetest.settings:get("selfcare.condish_timer")) or 3600
selfcare.t_t = tonumber(minetest.settings:get("selfcare.teeth_timer")) or 126000
selfcare.b_t = tonumber(minetest.settings:get("selfcare.breath_timer")) or 1200
selfcare.fs_t = tonumber(minetest.settings:get("selfcare.skin_timer")) or 2400
selfcare._fs_t = tonumber(minetest.settings:get("selfcare.dryness_timer")) or 2700
selfcare.p_t = tonumber(minetest.settings:get("selfcare.pimples_timer")) or 3600
selfcare.pp_t = tonumber(minetest.settings:get("selfcare.pimpatch_timer")) or 1800
selfcare.pf_t = tonumber(minetest.settings:get("selfcare.perfume_timer")) or 2400
selfcare.bdr_t = tonumber(minetest.settings:get("selfcare.body_dryness_timer")) or 660
selfcare.bdi_t = tonumber(minetest.settings:get("selfcare.body_dirt_timer")) or 1200
selfcare.bi_t = tonumber(minetest.settings:get("selfcare.body_itch_timer")) or 1500
selfcare._t_t = tonumber(minetest.settings:get("selfcare._teeth_timer")) or 1200
selfcare.to_t = tonumber(minetest.settings:get("selfcare.tongue_timer")) or 1900
selfcare.t_w_t = tonumber(minetest.settings:get("selfcare.t_whitening_timer")) or 1200


minetest.register_globalstep(function(dtime)
    for _, player in ipairs(minetest.get_connected_players()) do
	local n = player:get_player_name()

    if selfcare.get(player, "selfcare") then

	    if not selfcare_timers[n] then
		selfcare_timers[n] = {
		   s_t = tn(selfcare.get(player, "smell_t")) or 0,
		   h_t = tn(selfcare.get(player, "hair_t")) or 0,
		   c_t = tn(selfcare.get(player, "condish_t")) or 0,
		   t_t = tn(selfcare.get(player, "teeth_t")) or 0,
		   b_t = tn(selfcare.get(player, "breath_t")) or 0,
		   p_t = tn(selfcare.get(player, "pimples_t")) or 0,
		   pp_t = tn(selfcare.get(player, "pimpatch_t")) or 0,
		   fs_t = tn(selfcare.get(player, "faceskin_t")) or 0,
		   _fs_t = tn(selfcare.get(player, "_faceskin_t")) or 0,
		   pf_t = tn(selfcare.get(player, "perfume_t")) or 0,
		   bdr_t = tn(selfcare.get(player, "b_dryness_t")) or 0,
		   bdi_t = tn(selfcare.get(player, "b_dirtiness_t")) or 0,
		   bi_t = tn(selfcare.get(player, "b_itchiness_t")) or 0,
		   _t_t = tn(selfcare.get(player, "_teeth_t")) or 0,
		   to_t = tn(selfcare.get(player, "tongue_t")) or 0,
		   t_w_t = tn(selfcare.get(player, "t_whitening_t")) or 0
		}
	    end

	for timer, _ in pairs(selfcare_timers[n]) do
	    selfcare_timers[n][timer] = selfcare_timers[n][timer] + dtime
	end


--		[ individual timers ]

    if selfcare_timers[n].s_t >= selfcare.s_t then
	 local smell = selfcare.get(player, "smell")
	if smell == "clean" then
	   selfcare.set(player, "smell", "neutral")
	elseif smell == "neutral" then
	   selfcare.set(player, "smell", "bad")
	   selfcare.send(n, "I stink!")
	end
	selfcare_timers[n].s_t = 0
    end

    if selfcare_timers[n].h_t >= selfcare.h_t then
	 local hair = selfcare.get(player, "hair")
	if hair == "clean" then
	   selfcare.set(player, "hair", "dirty")
	   selfcare.send(n, "I should wash my hair now..")
	end
	selfcare_timers[n].h_t = 0
    end

    if selfcare_timers[n].c_t >= selfcare.c_t then
	 local condish = selfcare.get(player, "condish")
	if condish == "soft" then
	   selfcare.set(player, "condish", "dry")
	elseif condish == "dry" then
	   selfcare.set(player, "condish", "dehydrated")
	end
	selfcare_timers[n].c_t = 0
    end

    if selfcare_timers[n].t_t >= selfcare.t_t then
	 local teeth = selfcare.get(player, "teeth")
	if teeth == "white" then
	   selfcare.set(player, "teeth", "ivory")
	elseif teeth == "ivory" then
	   selfcare.set(player, "teeth", "cream")
	elseif teeth == "cream" then
	   selfcare.set(player, "teeth", "slightly yellow")
	   selfcare.send(n, "Uhh my teeth look weird-")
	elseif teeth == "slightly yellow" then
	   selfcare.set(player, "teeth", "yellow")
	   selfcare.send(n, "My teeth look so gross!")
	end
	selfcare_timers[n].t_t = 0
    end

    if selfcare_timers[n].t_w_t == (selfcare.t_w_t / 2) then
	selfcare.send(n, "your teeth are being whitened..")
    end

    if selfcare_timers[n].t_w_t >= selfcare.t_w_t then
	 local t = selfcare.get(player, "teeth")
	if selfcare.get(player, "t_whitening") == "yes" then
	    if t == "yellow" then
		selfcare.set("teeth", "slightly yellow")
	    elseif t == "slightly yellow" then
		selfcare.set("teeth", "cream")
	    elseif t == "cream" then
		selfcare.set("teeth", "ivory")
	    elseif t == "ivory" then
		selfcare.set("teeth", "white")
	    end
	    selfcare.set("t_whitening", "no")
	    selfcare.set("teeth_t", "0")
	end
	selfcare_timers[n].t_w_t = 0
    end


    if selfcare_timers[n].b_t >= selfcare.b_t then
	 local breath = selfcare.get(player, "breath")
	if breath == "minty" then
	   selfcare.set(player, "breath", "neutral")
	elseif breath == "fresh" then
	   selfcare.set(player, "breath", "neutral")
	elseif breath == "neutral" then
	   selfcare.set(player, "breath", "slightly bad")
	elseif breath == "slightly bad" then
	   selfcare.set(player, "breath", "bad")
	   selfcare.send(n, "I need to brush my teeth")
	elseif breath == "bad" then
	   selfcare.set(player, "breath", "disgusting")
	   selfcare.send(n, "Ew my breath could kill")
	end
	selfcare_timers[n].b_t = 0
    end

    if selfcare_timers[n].fs_t >= selfcare.fs_t then
	 local faceskin = selfcare.get(player, "faceskin")
	if faceskin == "clean" then
	   selfcare.set(player, "faceskin", "dirty")
	elseif faceskin == "dirty" and math.random(1,11) < 5 then
	   selfcare.set(player, "faceskin", "clogged")
	   selfcare.set(player, "_faceskin", "oily")
	   selfcare.send(n, "Is my skin clogged?")
	end
	selfcare_timers[n].fs_t = 0
    end

    if selfcare_timers[n]._fs_t >= selfcare._fs_t then
	 local _faceskin = selfcare.get(player, "_faceskin")
	if _faceskin == "soft" then
	   selfcare.set(player, "_faceskin", "dry")
	end
	selfcare_timers[n]._fs_t = 0
    end

    if selfcare_timers[n].p_t >= selfcare.p_t then
	 local faceskin = selfcare.get(player, "faceskin")
	if faceskin == "clogged" then
	  local pimple_num = tn(selfcare.get(player, "pimples")) + 1
	    if pimple_num > 6 then pimple_num = 6
	       selfcare.send(n, "My face hurts")
	    end
	   selfcare.set(player, "pimples", ts(pimple_num))
	end
	selfcare_timers[n].p_t = 0
    end

    if selfcare_timers[n].pp_t >= selfcare.pp_t then
	 local pimpatch = selfcare.get(player, "pimpatch")
	if pimpatch == "yes" then
	  local pimples = tn(selfcare.get(player, "pimples")) - 1
	    if pimples < 0 then pimples = 0 end
	   selfcare.set(player, "pimples", ts(pimples))
	   selfcare.set(player, "pimpatch", "no")
	end
	selfcare_timers[n].pp_t = 0
    end

    if selfcare_timers[n].pf_t >= selfcare.pf_t then
	 local perfume = selfcare.get(player, "perfume")
	if perfume == "are" then
	   selfcare.set(player, "perfume", "aren't")
	end
	selfcare_timers[n].pf_t = 0
    end

    if selfcare_timers[n]._t_t >= selfcare._t_t then
	 local crevaces = selfcare.get(player, "_teeth")
	if crevaces == "nothing" then
	   selfcare.set(player, "_teeth", "some dirt")
	elseif crevaces == "some dirt" then
	   selfcare.set(player, "_teeth", "build-up")
	elseif crevaces == "build-up" then
	   selfcare.set(player, "_teeth", "plaque")
	elseif crevaces == "plaque" then
	   selfcare.set(player, "_teeth", "a plaque colony")
	end
	selfcare_timers[n]._t_t = 0
    end

    if selfcare_timers[n].to_t >= selfcare.to_t then
	 local to = selfcare.get(player, "tongue")
	if to == "pink" then
	   selfcare.set(player, "tongue", "peach")
	elseif to == "peach" then
	   selfcare.set(player, "tongue", "yellow")
	end
	selfcare_timers[n].to_t = 0
    end

    if selfcare_timers[n].bdr_t >= selfcare.bdr_t then -- dryness
	 local skin = selfcare.get(player, "b_dryness")
	if skin == "smooth" then
	   selfcare.set(player, "b_dryness", "soft")
	elseif skin == "soft" then
	   selfcare.set(player, "b_dryness", "normal")
	elseif skin == "normal" then
	   selfcare.set(player, "b_dryness", "slightly dry")
	elseif skin == "slightly dry" then
	   selfcare.set(player, "b_dryness", "slightly flaky")
	elseif skin == "dry" then
	   selfcare.set(player, "b_dryness", "flaky")
	end
	selfcare_timers[n].bdr_t = 0
    end

    if selfcare_timers[n].bdi_t >= selfcare.bdi_t then -- dirtiness
	 local dry = selfcare.get(player, "b_dryness") -- dryness = flaky dead skin = dirty
	 local skin = selfcare.get(player, "b_dirtiness")
	if dry == "slightly flaky" then
	    if skin == "clean" then
		selfcare.set(player, "b_dirtiness", "neutral")
	    elseif skin == "neutral" then
		selfcare.set(player, "b_dirtiness", "slightly unclean")
	    elseif skin == "slightly unclean" then
		selfcare.set(player, "b_dirtiness", "slightly dirty")
	    elseif skin == "slightly dirty" then
		selfcare.set(player, "b_dirtiness", "dirty")
	    elseif skin == "dirty" then
		selfcare.set(player, "b_dirtiness", "grimy")
	    end
	elseif dry == "flaky" then
	    if skin == "clean" or skin ==  "neutral" then
		selfcare.set(player, "b_dirtiness", "slightly dirty")
	    elseif skin == "slightly dirty" or skin == "slightly unclean" then
		selfcare.set(player, "b_dirtiness", "dirty")
	    elseif skin == "dirty" then
		selfcare.set(player, "b_dirtiness", "grimy") 
	    end
	end
	selfcare_timers[n].bdi_t = 0
    end

    if selfcare_timers[n].bi_t >= selfcare.bi_t then -- itchiness
	 local dry = selfcare.get(player, "b_dryness")
	 local dirt = selfcare.get(player, "b_dirtiness")
	 local itch = selfcare.get(player, "b_itchiness")
	if dry == "slightly flaky" then
	    if dirt == "dirty" then if math.random(1,4) < 2 then
		if itch == "not" then
		    selfcare.set(player, "b_itchiness", "a bit")
		elseif itch == "a bit" then
		    selfcare.set(player, "b_itchiness", "")
		elseif itch == "" then
		    selfcare.set(player, "b_itchiness", "very")
		end
	    end end
	elseif dry == "flaky" then
	    if dirt == "slightly dirty" then if math.random(1,3) < 2 then
		if itch == "not" then
		    selfcare.set(player, "b_itchiness", "a bit")
		elseif itch == "a bit" then
		    selfcare.set(player, "b_itchiness", "")
		elseif itch == "" then
		    selfcare.set(player, "b_itchiness", "very")
		elseif itch == "very" then
		    selfcare.set(player, "b_itchiness", "irritatingly")
		elseif itch == "irritatingly" then
		    selfcare.set(player, "b_itchiness", "concerningly")
		end
	    end end

	-- [ now for self-repairing any damage ] 

	elseif dry == "slightly dry" or dry == "normal" then
	    if itch == "concerningly" then
		selfcare.set(player, "b_itchiness", "irritatingly")
	    elseif itch == "irritatingly" then
		selfcare.set(player, "b_itchiness", "very")
	    elseif itch == "very" then
		selfcare.set(player, "b_itchiness", "")
	    elseif itch == "" then
		selfcare.set(player, "b_itchiness", "a bit")
	    elseif itch == "a bit" then
		selfcare.set(player, "b_itchiness", "not")
	    end
	elseif dry == "soft" or dry == "smooth" then
	    if itch == "concerningly" then
		selfcare.set(player, "b_itchiness", "very")
	    elseif itch == "very" then
		selfcare.set(player, "b_itchiness", "a bit")
	    elseif itch == "a bit" then
		selfcare.set(player, "b_itchiness", "not")
	    end
	end
	selfcare_timers[n].bi_t = 0
    end


--		[ memorize timers ]

	selfcare.set(player, "smell_t", ts(selfcare_timers[n].s_t))
	selfcare.set(player, "hair_t", ts(selfcare_timers[n].h_t))
	selfcare.set(player, "condish_t", ts(selfcare_timers[n].c_t))
	selfcare.set(player, "teeth_t", ts(selfcare_timers[n].t_t))
	selfcare.set(player, "breath_t", ts(selfcare_timers[n].b_t))
	selfcare.set(player, "faceskin_t", ts(selfcare_timers[n].fs_t))
	selfcare.set(player, "_faceskin_t", ts(selfcare_timers[n]._fs_t))
	selfcare.set(player, "pimples_t", ts(selfcare_timers[n].p_t))
	selfcare.set(player, "pimpatch_t", ts(selfcare_timers[n].pp_t))
	selfcare.set(player, "perfume_t", ts(selfcare_timers[n].pf_t))
	selfcare.set(player, "_teeth_t", ts(selfcare_timers[n]._t_t))
	selfcare.set(player, "tongue_t", ts(selfcare_timers[n].to_t))
	selfcare.set(player, "b_dryness_t", ts(selfcare_timers[n].bdr_t))
	selfcare.set(player, "b_dirtiness_t", ts(selfcare_timers[n].bdi_t))
	selfcare.set(player, "b_itchiness_t", ts(selfcare_timers[n].bi_t))

	end
    end
end)