selfcare.effect = {}

local random = math.random

local function stray_bubble(player, height)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - height

      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.1, y = pos.y + eye, z = pos.z + dir.z * 0.1},
	time = 0.1,
	amount = 2,
	vel = {min = {x = -0.15, y = -0.15, z = -0.15}, max = {x = 0.15, y = -0.19, z = 0.15}},
	acc = {min = {x = 0.15, y = 0.17, z = 0.15}, max = {x = -0.15, y = 0.23, z = -0.15}},
	size = {min = 1, max = 2},
	texture = "selfcare_stray_bubble.png",
	collisiondetection = true,
	collision_removal = true,
	minexptime = 2,
	maxexptime = 3
})
end


local function WashBody(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - math.random(0.3, 0.4)
        

	stray_bubble(player, math.random(0.3, 0.7))
      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.05, y = pos.y + eye, z = pos.z + dir.z * 0.1},
	time = 0.1,
	amount = 6,
	vel = {min = {x = -0.45, y = 0.2, z = -0.45}, max = {x = 0.45, y = 0.3, z = 0.45}},
	acc = {x = 0, y = -1.7, z = 0},
	size = {min = 3, max = 4},
	texture = "selfcare_bubble.png",
	collisiondetection = true,
	minexptime = 1.3,
	maxexptime = 2
})
end

local function WashHair(player, hex)
    local pos = player:get_pos()
    local eye = player:get_properties().eye_height + 0.33

    local textures = {"selfcare_bubble.png", "selfcare_stray_bubble.png^(selfcare_stray_bubble.png^[multiply:"..hex.."^[opacity:230)"}
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + eye, z = pos.z},
	time = 0.1,
	amount = 5,
	vel = {min = {x = -0.7, y = 0.3, z = -0.7}, max = {x = 0.7, y = 0.55, z = 0.7}},
	acc = {x = 0, y = -2, z = 0},
	size = {min = 2, max = 3},
	texture = textures[math.random(2)],
	collisiondetection = true,
	minexptime = 0.4,
	maxexptime = 0.6
})
end

local function CondishHair(player, typ)
    local pos = player:get_pos()
    local eye = player:get_properties().eye_height + 0.33
    local textures = {tx = "selfcare_cream.png"}

if typ == "gel" then
    textures.tx = "selfcare_light_cream.png"
end
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + eye, z = pos.z},
	time = 0.1,
	amount = 5,
	vel = {min = {x = -0.7, y = 0.3, z = -0.7}, max = {x = 0.7, y = 0.55, z = 0.7}},
	acc = {x = 0, y = -2, z = 0},
	size = {min = 2, max = 3},
	texture = textures.tx,
	collisiondetection = true,
	minexptime = 0.4,
	maxexptime = 0.6
})
end

local function BrushTeeth(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - 0.1
        
      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.2, y = pos.y + eye, z = pos.z + dir.z * 0.3},
	time = 0.1,
	amount = 25,
	vel = {min = {x = -0.2, y = 0.4, z = -0.2}, max = {x = 0.2, y = 0.4, z = 0.2}},
	acc = {x = 0, y = -1, z = 0},
	size = {min = 1, max = 1.5},
	texture = "selfcare_bubble.png^[multiply:#c8eced",
	collisiondetection = true,
	minexptime = 0.3,
	maxexptime = 0.5
})
end
local function ScrapeTongue(player, hex)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - 0.1

      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.1, y = pos.y + eye, z = pos.z + dir.z * 0.21},
	time = 0.1,
	amount = 10,
	vel = {min = {x = -0.2, y = 0, z = -0.2}, max = {x = 0.2, y = 0, z = 0.2}},
	acc = {x = 0, y = 0, z = 0},
	size = {min = 1, max = 1},
	texture = "selfcare_cream.png^[multiply:"..hex,
	collisiondetection = true,
	minexptime = 0.2,
	maxexptime = 0.4
})
end

local washface_txt = {"selfcare_bubble.png", "selfcare_bubble.png^[multiply:#fff4ed"}

local function WashFace(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height + 0.14
        
      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.1, y = pos.y + eye, z = pos.z + dir.z * 0.2},
	time = 0.1,
	amount = 5,
	vel = {min = {x = -0.2, y = -0.4, z = -0.2}, max = {x = 0.2, y = -0.5, z = 0.2}},
	acc = {x = 0, y = 0.5, z = 0},
	size = {min = 1, max = 1.5},
	texture = washface_txt[random(#washface_txt)],
	collisiondetection = true,
	minexptime = 1,
	maxexptime = 1.5
})
end

local function Perfume(player, tint)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - 0.6
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + eye, z = pos.z},
	time = 0.1,
	amount = 15,
	vel = {min = {x = -0.2, y = 0.2, z = -0.2}, max = {x = 0.2, y = 0.3, z = 0.2}},
	acc = {min = {x = -0.1, y = -0.2, z = -0.1}, max = {x = 0.1, y = -0.3, z = 0.1}},
	size = {min = 7, max = 10},
	texture = "selfcare_spray.png^[multiply:"..tint.."^[opacity:50",
	collisiondetection = false,
	minexptime = 1.5,
	maxexptime = 3
})
end


local function effect(player, type, height, min_size, max_size, min_exp, max_exp, hex)
    local pos = player:get_pos()
    local offs = player:get_properties().eye_height + height

    local cream_tex
    local spray_tex

if hex then
    cream_tex = "selfcare_cream.png^(selfcare_cream.png^[opacity:170^[multiply:"..hex..")"
    spray_tex = "(selfcare_spray.png^[opacity:200)^[multiply:"..hex
else
    cream_tex = "selfcare_cream.png^[opacity:200"
    spray_tex = "selfcare_spray.png^[opacity:200"
end

	if type == "cream" then
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + offs, z = pos.z},
	time = 0.1,
	amount = 7,
	vel = {min = {x = -0.7, y = 0.8, z = -0.7}, max = {x = 0.7, y = 1.2, z = 0.7}},
	acc = {x = 0, y = -4, z = 0},
	size = {min = min_size, max = max_size},
	texture = cream_tex,
	collisiondetection = true,
	minexptime = min_exp,
	maxexptime = max_exp
})
	elseif type == "spray" then
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + offs, z = pos.z},
	time = 0.1,
	amount = 11,
	vel = {min = {x = -0.7, y = 0.8, z = -0.7}, max = {x = 0.7, y = 1.2, z = 0.7}},
	acc = {x = 0, y = -4.8, z = 0},
	size = {min = min_size, max = max_size},
	texture = spray_tex,
	collisiondetection = true,
	minexptime = mix_exp,
	maxexptime = max_exp
})
	end
end

function selfcare.effect.WashBody(user, c)
    if c > 0 then
        WashBody(user)
        
        minetest.after(0.05, function()
            selfcare.effect.WashBody(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "smell", "clean")
	selfcare.set(user, "smell_t", "0")
	selfcare.set(user, "perfume", "aren't")
	selfcare.set(user, "perfume_t", "0")

	local bdr = selfcare.get(user, "b_dryness")
	local bdi = selfcare.get(user, "b_dirtiness")

	-- if the layer of dead skin cells is thin then it can be washed away with soap
	-- but in my head flaky skin would make it hard to remove, and might damage skin so

	if (bdr == "smooth" or bdr == "soft" or bdr == "normal") and
	(bdi == "neutral" or bdi == "slightly unclean") then
	    selfcare.set(user, "b_dirtiness", "clean")
	end
    end
end

function selfcare.effect.CondishHair(user, c)
    local hair_condition = selfcare.get(user, "condish")
    local dirt = selfcare.get(user, "hair")

    if c > 0 then
        CondishHair(user, "condish")
        
        minetest.after(0.2, function()
            selfcare.effect.CondishHair(user, c - 1)
        end)
    elseif c <= 0 then

	if hair_condition ~= "dehydrated" and dirt ~= "dirty" then
	  selfcare.set(user, "condish", "soft")
	  selfcare.set(user, "condish_t", "0")
	end

    end
end

function selfcare.effect.GelHair(user, c)
    local hair_condition = selfcare.get(user, "condish")
    local dirt = selfcare.get(user, "hair")

    if c > 0 then
        CondishHair(user, "gel")
        
        minetest.after(0.2, function()
            selfcare.effect.GelHair(user, c - 1)
        end)
    elseif c <= 0 then

	if hair_condition ~= "dehydrated" and dirt ~= "dirty" then
	  selfcare.set(user, "condish", "soft")
	  selfcare.set(user, "condish_t", "0")
	end

    end
end

function selfcare.effect.MaskHair(user, c, clr)
    local hair_condition = selfcare.get(user, "condish")

    if c > 0 then
	for i = 1, 3 do
        effect(user, "cream", 0.3, 2, 3, 0.3, 0.4)
        effect(user, "cream", 0.3, 1.5, 2.5, 0.4, 0.6, clr)
        CondishHair(user, "gel")
	end
        
        minetest.after(0.2, function()
            selfcare.effect.MaskHair(user, c - 1, clr)
        end)
    elseif c <= 0 then
	  selfcare.set(user, "condish", "soft")
	  selfcare.set(user, "condish_t", "0")
    end
end


function selfcare.effect.WashHair(user, c, clr)
    if c > 0 then
        WashHair(user, clr)
        
        minetest.after(0.05, function()
            selfcare.effect.WashHair(user, c - 1, clr)
        end)
    elseif c <= 0 then
	selfcare.set(user, "hair_t", "0")
	selfcare.set(user, "hair", "clean")
    end
end

function selfcare.effect.BrushTeeth(user, c)
    if c > 0 then
        BrushTeeth(user)
        
        minetest.after(0.2, function()
            selfcare.effect.BrushTeeth(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "teeth_t", "0")
	selfcare.set(user, "breath_t", "0")
	selfcare.set(user, "breath", "minty")
	selfcare.set(user, "breath_t", "0")
    end
end

function selfcare.effect.WashFace(user, c)
    local _f = selfcare.get(user, "_faceskin")

    if c > 0 then
        WashFace(user)
        
        minetest.after(0.05, function()
            selfcare.effect.WashFace(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "faceskin", "clean")
	selfcare.set(user, "faceskin_t", "0")

	if _f == "oily" then
	  selfcare.set(user, "_faceskin", "dry")
	end
    end
end

function selfcare.effect.Perfume(user, c, tint)
    if c > 0 then
        Perfume(user, tint)
        
        minetest.after(0.2, function()
            selfcare.effect.Perfume(user, c - 1, tint)
        end)
    elseif c <= 0 then
	selfcare.set(user, "perfume", "are")
	selfcare.set(user, "perfume_t", "0")
    end
end

local function CreamFace(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height + 0.1
        
      minetest.add_particlespawner({
	pos = {x = pos.x + dir.x * 0.1, y = pos.y + eye, z = pos.z + dir.z * 0.3},
	time = 0.1,
	amount = 20,
	vel = {min = {x = -0.2, y = 0.2, z = -0.2}, max = {x = 0.2, y = 0.2, z = 0.2}},
	acc = {min = {x = -0.2, y = -1, z = -0.2}, max = {x = 0.2, y = -1, z = 0.2}},
	size = {min = 1, max = 1.5},
	texture = "selfcare_spray.png",
	collisiondetection = true,
	minexptime = 0.5,
	maxexptime = 1
})
end

local function BodyLotion(player)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - 0.47
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + eye, z = pos.z},
	time = 0.1,
	amount = 6,
	vel = {min = {x = -0.3, y = 0.4, z = -0.3}, max = {x = 0.3, y = 0.4, z = 0.3}},
	acc = {min = {x = -0.1, y = -0.9, z = -0.1}, max = {x = 0.1, y = -0.9, z = 0.1}},
	size = {min = 7, max = 9},
	texture = "selfcare_spray.png^[opacity:120",
	collisiondetection = true,
	minexptime = 1,
	maxexptime = 1.7
})
end

local function BodyScrub(player, hex)
    local pos = player:get_pos()
    local dir = player:get_look_dir()
    local eye = player:get_properties().eye_height - 0.65
        
      minetest.add_particlespawner({
	pos = {x = pos.x, y = pos.y + eye, z = pos.z},
	time = 0.1,
	amount = 20,
	vel = {min = {x = -0.3, y = 1.2, z = -0.3}, max = {x = 0.3, y = 1.7, z = 0.3}},
	acc = {min = {x = 0.3, y = -2.5, z = 0.3}, max = {x = -0.3, y = -3, z = -0.3}},
	size = {min = 3, max = 5},
	texture = "selfcare_scrub.png^[multiply:"..hex,
	collisiondetection = true,
	minexptime = 1.3,
	maxexptime = 1.45
})
end

function selfcare.effect.CreamFace(user, c)
    local f = selfcare.get(user, "faceskin")

    if c > 0 then
        CreamFace(user)
        
        minetest.after(0.2, function()
            selfcare.effect.CreamFace(user, c - 1)
        end)
    elseif c <= 0 then
	selfcare.set(user, "_faceskin", "soft")
	selfcare.set(user, "_faceskin_t", "0")

	if f == "dirty" then
	  selfcare.set(user, "faceskin", "clogged")
	  selfcare.set(user, "_faceskin", "oily")
	end	   
    end
end

function selfcare.effect.FlossTeeth(user)
    local t = selfcare.get(user, "_teeth")

	if t == "a plaque colony" then -- must pass it multiple times to clean properly ;)
	  selfcare.set(user, "_teeth", "plaque")
	elseif t == "plaque" then
	  selfcare.set(user, "_teeth", "build-up")
	elseif t == "build-up" then
	  selfcare.set(user, "_teeth", "some dirt")
	elseif t == "some dirt" then
	  selfcare.set(user, "_teeth", "nothing")
	  minetest.chat_send_player(user:get_player_name(), "no plaque between my teeth!")
	end
    selfcare.set(user, "_teeth_t", "0")
end

function selfcare.effect.BodyLotion(user, c)
    local d = selfcare.get(user, "b_dryness")

    if c > 0 then
        BodyLotion(user)
        
        minetest.after(0.2, function()
            selfcare.effect.BodyLotion(user, c - 1)
        end)
    elseif c <= 0 then

	if d == "flaky" or d == "slightly flaky" then
	    selfcare.set(user, "b_dryness", "slightly dry")
	elseif d == "slightly dry" then
	    selfcare.set(user, "b_dryness", "normal")
	elseif d == "normal" or d == "soft" then
	    selfcare.set(user, "b_dryness", "smooth")
	end
    end
    selfcare.set(user, "b_dryness_t", "0")
end

function selfcare.effect.BodyScrub(user, c, clr)
    local d = selfcare.get(user, "b_dirtiness")

    if c > 0 then
        BodyScrub(user, clr)
        WashBody(user)
        
        minetest.after(0.2, function()
            selfcare.effect.BodyScrub(user, c - 1, clr)
        end)
    elseif c <= 0 then

	if d == "grimy" or d == "dirty" then
	  selfcare.set(user, "b_dirtiness", "slightly dirty")
	elseif d == "slightly dirty" or d == "slightly unclean" or d == "neutral" then
	  selfcare.set(user, "b_dirtiness", "clean")
	end
    end
    selfcare.set(user, "b_dirtiness_t", "0")
end

function selfcare.effect.ScrapeTongue(user, c)
    local t = selfcare.get(user, "tongue")
    local br = selfcare.get(user, "breath")
    local hex = "#FFD8DA"

if t == "pink" then hex = "#FFD8DA"
elseif t == "peach" then hex = "#FFD1C6"
elseif t == "yellow" then hex = "#FFD8AD"
else return
end

    if c > 0 then
        ScrapeTongue(user, hex)
        
        minetest.after(0.2, function()
            selfcare.effect.ScrapeTongue(user, c - 1)
        end)
    elseif c <= 0 then
	if br == "disgusting" or br == "bad" then
	    selfcare.set(user, "breath", "slightly bad")
	end
	if t == "yellow" then
	    selfcare.set(user, "tongue", "peach")
	elseif t == "peach" then
	    selfcare.set(user, "tongue", "pink")
	end
    end
end