local color = minetest.colorize

local ITEMS = {
{"white_loofah", "White Loofah", "loofah", 320, 200},
{"floral_bodysoap", color("#ffe0dd", "Floral").." Bodysoap", "bodysoap", 0, 0},
{"almond_bodysoap", color("#b58b80", "Almond").." Bodysoap", "bodysoap", 0, 0},
{"coco_bodyscrub", color("#af9092", "Coconut").." Body Scrub", "bodyscrub", 40, 11, "#af9092"},
{"tropical_bodyscrub", color("#ffb08a", "Tropical").." Body Scrub", "bodyscrub", 45, 11, "#ffb08a"},
{"sugar_bodyscrub", color("#c9a284", "Pure Sugar").." Body Scrub", "bodyscrub", 50, 13, "#c9a284"},
{"strawberry_bodyscrub", color("#ffb5af", "Strawberry").." Body Scrub", "bodyscrub", 40, 11, "#ffb5af"},
{"banana_bodyscrub", color("#fed792", "Banana").." Body Scrub", "bodyscrub", 40, 11, "#fed792"},
{"vanilla_bodyscrub", color("#fdf1ce", "Vanilla").." Body Scrub", "bodyscrub", 45, 12, "#7f5f46"},
{"almond_bodylotion", color("#b17b66", "Almond").." Bodymilk\nall skin types", "lotion", 20, 14}, -- had to change name from bodymilk to bodylotion bc tph_eating tried to eat it lmao
{"almond_bodylotion", color("#b17b66", "Almond").." Bodymilk\nall skin types", "lotion", 20, 14},
{"argan_bodyoil", color("#DB957D", "Argan").." Body Oil\n -\nfor "..color("#FFB8F7", "dry")..", "..color("#FFB8D2", "itchy").." skin", "lotionx2", 8, 23, "body"},
{"toothbrush", "Toothbrush", "toothbrush", 15, 115},
{"whitening_strips", "Box of 4 Teeth-whitening Strips", "teeth_whitening", 0, 3},
{"tongue_scraper", "Tongue Scraper", "tonguescraper", 3, 0},
{"wooden_toothbrush", color("#ffd7b6", "Wooden").." Toothbrush", "toothbrush", 15, 110},
{"floss", color("#8ed1ff", "Dental").. " Floss", "floss", 0, 130},
{"coco_toothpaste", color("#89675a", "Coconut").." Toothpaste\n whitening\n strengthening\n "..color("#FFCECF", "sensitive"), "toothpaste", 0, 0},
{"mint_toothpaste", color("#9fd1b3", "Mint").." Toothpaste\n refreshing\n"..color("#FFCECF", "anti-plaque").."\nstrengthening", "toothpaste", 0, 0},
{"rosewater_condish", "Conditioner\n"..color("#ffbcc6", "rosewater extracts"), "condish", 14, 17},
{"shea_condish", color("#fce09c", "Shea Butter").." Conditioner\n"..color("#fccf9c", "for thick, coarse hair"), "condish", 24, 19},
{"curl_gel", color("#ffdfc9", "Silicone-Free").." Gel\nno parabens!\n"..color("#f7b6c5", "curl-friendly"), "gel", 10, 13}, 
{"rosemary_shampoo", color("#ff95af", "Rosemary").." Shampoo\n hair growth", "shampoo", 120, 17, "#ffcbd3"}, 
{"coffee_shampoo", color("#94746f", "Coffee").." Shampoo", "shampoo", 148, 19, "#deb9b4"}, 
{"curl_shampoo", color("#ff6f8f", "Sulfate-Free").." Shampoo\nno parabens\n"..color("#f7b6c5", "curl-friendly"), "shampoo", 120, 17, "#f794ab"}, 
--{"straightener", color("#ffd0d1", "Hair Straightener"), "straightener", 120, 210}, 
{"egg_hairmask", color("#ffb359", "Egg").." Hairmask", "hairmask", 30, 2, "#ffb359"},
{"banana_hairmask", color("#ffd26c", "Banana").." Hairmask", "hairmask", 40, 4, "#FFD26C"},
{"oat_facesoap", "Face Soap\n"..color("#dfbda1", "Oat Extracts"), "facesoap", 120, 15},
{"heartleaf_moisturiser", color("#ffdcf3", "Heartleaf").." Face Cream", "moisturizer", 20, 19},
{"pimplepatch", "5 "..color("#ffdad8", "Pimple").." Patches", "pimpatch", 0, 4},
{"vanilla_perfume", color("#fce2ca", "Vanilla").." Perfume\naromas:\n"..color("#755046", "  cocoa\n")..color("#D7B798", "  vanilla\n")..color("#925e53", "  sandalwood"), "perfume", 8, 100, "#fce2ca"},
{"goddess_bubblebomb", color("#EDD5B4", "[Goddess]").." Bubble Bomb", "bubblebomb", 620, 5, "#FEF1DD"},
{"lily_bubblebomb", color("#FFC8CD", "[Water Lily]").." Bubble bomb", "bubblebomb", 555, 5, "#AED7A1"},
}

for i in ipairs(ITEMS) do
  local name = ITEMS[i][1]
  local desc = ITEMS[i][2]
  local type = ITEMS[i][3]
  local c    = ITEMS[i][4]
  local uses = ITEMS[i][5]
  local clr = ITEMS[i][6]


selfcare.add_product("self_care:"..name, {
    description = desc,
    inventory_image = "selfcare_"..name..".png",
    groups = { selfcare = 1 },
    on_use = function(itemstack, user, pointed_thing)
      local u = user:get_player_name()

	-- to prevent useless wearing
	if type == "teeth_whitening" and selfcare.get(user, "t_whitening") == "yes" then
		selfcare.send(u, "you've already used whitening strips")
	    return
	end
	if type == "pimpatch" and selfcare.get(user, "pimpatch") == "yes" then
		selfcare.send(u, "you've already put on a pimple patch")
	    return
	end

	if type == "loofah" then
	    selfcare.func.Loofah(itemstack, user, c, uses)
	elseif type == "lotion" then
	    selfcare.effect.BodyLotion(user, c)
	elseif type == "bodyscrub" then
	    selfcare.effect.BodyScrub(user, c, clr)
	    selfcare.effect.WashBody(user, c * 4, "rinsing")
	elseif type == "bubblebomb" then
	    selfcare.effect.BubbleBomb(user, c, clr)
	elseif type == "lotionx2" then
	    selfcare.effect.OilPlayer(user, c, clr)
	elseif type == "toothbrush" then
	    selfcare.func.Toothbrush(itemstack, user, c)
	elseif type == "floss" then
	    selfcare.effect.FlossTeeth(user)
	elseif type == "tonguescraper" then
	    selfcare.effect.ScrapeTongue(user, c)
	elseif type == "shampoo" then
	    selfcare.effect.WashHair(user, c, clr)
	elseif type == "gel" then
	    selfcare.effect.GelHair(user, c)
	elseif type == "condish" then
	    selfcare.effect.CondishHair(user, c)
	elseif type == "hairmask" then
	    selfcare.effect.MaskHair(user, c, clr)
	elseif type == "perfume" then
	    selfcare.effect.Perfume(user, c, clr)
	elseif type == "facesoap" then
	    selfcare.effect.WashFace(user, c)
	elseif type == "moisturizer" then
	    selfcare.effect.CreamFace(user, c)
	elseif type == "pimpatch" then
	  if selfcare.get(user, "pimpatch") ~= "yes" then
	    selfcare.set(user, "pimpatch", "yes")
	    selfcare.set(user, "pimpatch_t", "0")
	  end
	elseif type == "teeth_whitening" then
	  if selfcare.get(user, "t_whitening") ~= "yes" then
	    selfcare.set(user, "t_whitening", "yes")
	    selfcare.set(user, "t_whitening_t", "0")
	  end
	end



	itemstack:add_wear(65535 / uses)
	return itemstack
    end
})
end

--	[ misc ]

selfcare.add_item("self_care:cottonpad", {
    description = "Cottonpad",
    inventory_image = "selfcare_cottonpad.png"
})

selfcare.add_item("self_care:coconut_oil", {
    description = "Bottle of Coconut Oil",
    inventory_image = "selfcare_coconut_oil.png"
})

selfcare.add_block("self_care:wooden_mirror", {
    description = "Wooden Mirror",
    inventory_image = "selfcare_mirror_wf.png",
    wield_image = "selfcare_mirror_wf.png",
    tiles = {	"default_aspen_wood.png",
		"default_aspen_wood.png",
		"default_aspen_wood.png",
		"default_aspen_wood.png",
		"default_aspen_wood.png",
		"selfcare_mirror_wf.png"
	    },
    paramtype = "light",
    paramtype2 = "facedir",
    drawtype = "nodebox",
    groups = { cracky = 2 },
    node_box = {
	type = "fixed",
	fixed = {
		{-0.19, -0.325, 0.5, 0.25, 0.435, 0.45},
		{-0.25, 0.435, 0.5, 0.25, 0.375, 0.435}, -- top
		{-0.25, -0.325, 0.5, 0.25, -0.275, 0.435}, -- bottom
		{-0.25, -0.325, 0.5, -0.19, 0.435, 0.435}, -- left
		{0.25, -0.325, 0.5, 0.19, 0.435, 0.435}, -- right
		}
    },
    on_rightclick = function(pos, node, clicker)
	selfcare.form.Hygiene(clicker:get_player_name())
    end
})