local function use_hair_tool(plyr)
    local n = plyr:get_player_name()

    local heat = minetest.deserialize(selfcare.get(plyr, "hair_heating"))

    local temp = heat.temp
    local cob = 0

    if heat.protectant == "yes" then cob = 115 else cob = 60 end

    if temp > 200 then cob = cob - 20
      elseif temp > 180 then cob = cob - 12
      elseif temp > 140 then cob = cob - 5
    end

    if math.random(1, cob) == 1 then
	selfcare.set(plyr, "condish_t", "0")
	selfcare.set(plyr, "condish", "fried")
	selfcare.send(n, "I fried my hair!", "bad")
    else
	selfcare.set(plyr, "hair_tex", "straight")
	selfcare.send(n, "straightened hair", "positive")
    end
end

function selfcare.form.HeatTool(name)
    local plyr = minetest.get_player_by_name(name)
    local heat = minetest.deserialize(selfcare.get(plyr, "hair_heating"))
    local temp = heat.temp
    local clr = minetest.colorize

    local form =
	"size[3, 2]" ..
	"label[0,1;temperature:\n" .. math.floor(temp) .. " °C]" ..
	"image_button[-0.2,-0.3;1.8,1;selfcare_button.png^[opacity:200;on;"..clr("#55423E", "On").."]" ..
	"image_button[1.4,-0.3;1.8,1;selfcare_button.png^[opacity:200;off;"..clr("#55423E", "Off").."]" ..
	"image_button[1.5,0.7;1.7,0.5;selfcare_button.png^[opacity:200;t_180;"..clr("#55423E", "180 °C").."]" ..
	"image_button[1.5,1.3;1.7,0.5;selfcare_button.png^[opacity:200;t_200;"..clr("#55423E", "200 °C").."]" ..
	"image_button[1.5,1.9;1.7,0.5;selfcare_button.png^[opacity:200;t_220;"..clr("#55423E", "220 °C").."]"

    minetest.show_formspec(name, "self_care:heat_tool", form)
    return form
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "self_care:heat_tool" then return end
    local heat = minetest.deserialize(selfcare.get(player, "hair_heating"))

    if fields.t_180 then
	heat.target_temp = 180
    elseif fields.t_200 then
	heat.target_temp = 200
    elseif fields.t_220 then
	heat.target_temp = 220
    elseif fields.on then
	heat.heat_tool = "on"
	heat.heating = "yes"
	selfcare.send(player:get_player_name(), "straightener turned on", "info")
    elseif fields.off then
	heat.heat_tool = "off"
	heat.heating = "not"
	selfcare.send(player:get_player_name(), "straightener turned off", "info")
    end

    selfcare.set(player, "hair_heating", minetest.serialize(heat))
    selfcare.form.HeatTool(player:get_player_name())

end)

local heating_t = 0
local duration = 0
minetest.register_globalstep(function(dtime)

    heating_t = heating_t + dtime
    if heating_t < 0.2 then return end

  for _, player in ipairs(minetest.get_connected_players()) do
    local n = player:get_player_name()
    local heat = minetest.deserialize(selfcare.get(player, "hair_heating"))

    local heating = heat.heating
    local temp = heat.temp
    local target_temp = heat.target_temp
    local tool = heat.heat_tool


	if tool == "on" then
	    heat.heating = "yes"
	    selfcare.effect.SteamHair(player, temp)
	  if temp == target_temp then
	    duration = duration + dtime
	  end
	elseif tool == "off" then
	    heat.heating = "not"
	    duration = 0
	end
	if heating == "yes" then
	    if temp < target_temp then
		temp = temp + 0.5
	    end
	    if temp > target_temp then temp = target_temp end
	    heat.temp = temp
	else
	    if temp > 30 then
		temp = temp - 0.3
	    end
	    if temp < 30 then temp = 30 end
	    heat.temp = temp
	end


    if duration > (1500 / math.floor(temp)) then
	heat.heat_tool = "off"
	use_hair_tool(player)
	heat.protectant = "no"
	duration = 0
    end
    selfcare.set(player, "hair_heating", minetest.serialize(heat))
    heating_t = 0

  end
end)