-- Juicer
local S = minetest.get_translator("default")

minetest.register_craft({
	output = 'technic_farming:lv_juice_press',
	recipe = {
		{'basic_materials:motor', 'technic_farming:wooden_screw',          'group:wood'},
		{'technic_farming:wooden_plate', 'technic:machine_casing', 'technic_farming:cotton_filter'},
		{'group:wood', 'technic:lv_cable',       'group:wood'},
	}
})

technic.register_base_machine("technic_farming:lv_juice_press", {
	typename = "juicer",
	description = S("@1 Juicer", S("LV")),
	insert_object = technic.insert_object_unique_stack,
	can_insert = technic.can_insert_unique_stack,
	tier = "LV",
	speed = 1,
	demand = {200}
})

minetest.register_craft({
	output = 'technic_farming:mv_juice_press',
	recipe = {
		{'technic:stainless_steel_ingot', 'technic_farming:lv_juice_press', 'technic:stainless_steel_ingot'},
		{'pipeworks:tube_1',              'technic:mv_transformer',   'technic_farming:plastic_filter'},
		{'technic:stainless_steel_ingot', 'technic:mv_cable',         'technic:stainless_steel_ingot'},
	}
})

technic.register_base_machine("technic_farming:mv_juice_press", {
	typename = "juicer",
	description = S("@1 Juicer", S("MV")),
	insert_object = technic.insert_object_unique_stack,
	can_insert = technic.can_insert_unique_stack,
	tier = "MV",
	speed = 1.5,
	upgrade = 1,
	tube = 1,
	demand = {2000, 1800, 900}
})

minetest.register_craft({
	output = 'technic_farming:hv_juice_press',
	recipe = {
		{'technic:copper_plate', 'technic_farming:mv_juice_press', 'technic:copper_plate'},
		{'pipeworks:tube_1',              'technic:hv_transformer',   'technic_farming:carbon_filter'},
		{'technic:stainless_steel_ingot', 'technic:hv_cable',         'technic:stainless_steel_ingot'},
	}
})

technic.register_base_machine("technic_farming:hv_juice_press", {
	typename = "juicer",
	description = S("@1 Juicer", S("HV")),
	insert_object = technic.insert_object_unique_stack,
	can_insert = technic.can_insert_unique_stack,
	tier = "HV",
	speed = 2,
	upgrade = 1,
	tube = 1,
	demand = {3000, 2200, 1500}
})
