-- Juicer
local S = minetest.get_translator("default")

minetest.register_craft({
	output = 'tf_coffee:lv_coffeemaker',
	recipe = {
		{'basic_materials:motor', "vessels:steel_bottle",          'basic_materials:plastic_sheet'},
		{'basic_materials:heating_element', 'technic:machine_casing', 'technic_farming:cotton_filter'},
		{'basic_materials:plastic_sheet', 'technic:lv_cable',       'basic_materials:plastic_sheet'},
	}
})

technic.register_base_machine("tf_coffee:lv_coffeemaker", {
	typename = "brew",
	description = S("@1 Coffee Brewer", S("LV")),
	insert_object = technic.insert_object_unique_stack,
	can_insert = technic.can_insert_unique_stack,
	tier = "LV",
	speed = 1,
	demand = {200}
})

minetest.register_craft({
	output = "tf_coffee:mv_coffeemaker",
	recipe = {
		{'technic:stainless_steel_ingot', 'tf_coffee:lv_coffeemaker', 'technic:stainless_steel_ingot'},
		{'pipeworks:tube_1',              'technic:mv_transformer',   'technic_farming:plastic_filter'},
		{'technic:stainless_steel_ingot', 'technic:mv_cable',         'technic:stainless_steel_ingot'},
	}
})

technic.register_base_machine("tf_coffee:mv_coffeemaker", {
	typename = "brew",
	description = S("@1 Coffee Brewer", S("MV")),
	insert_object = technic.insert_object_unique_stack,
	can_insert = technic.can_insert_unique_stack,
	tier = "MV",
	speed = 1.5,
	upgrade = 1,
	tube = 1,
	demand = {1800, 1500, 900}
})
--[[
minetest.register_craft({
	output = 'technic_farming:hv_juice_press',
	recipe = {
		{'technic:copper_plate', 'technic_farming:mv_juice_press', 'technic:copper_plate'},
		{'pipeworks:tube_1',              'technic:hv_transformer',   'technic_farming:carbon_filter'},
		{'technic:stainless_steel_ingot', 'technic:hv_cable',         'technic:stainless_steel_ingot'},
	}
})

technic.register_base_machine("technic_farming:hv_juice_press", {
	typename = "juicer",
	description = S("@1 Juicer", S("HV")),
	insert_object = technic.insert_object_unique_stack,
	can_insert = technic.can_insert_unique_stack,
	tier = "HV",
	speed = 2,
	upgrade = 1,
	tube = 1,
	demand = {3000, 2200, 1500}
})
]]
