local S = minetest.get_translator("default")

local recipes = {
    {"ethereal:olive 4", tf_recipes.glass,"ethereal:olive_oil",3},
    {"farming:pineapple 2", tf_recipes.glass.." 2","farming:pineapple_juice 2",3},
    {"farming:corn 6", tf_recipes.glass,"farming:bottle_ethanol",3},
    {"farming:onion 5", tf_recipes.bowl,"farming:onion_soup",3},
}

-- generate recipe list out of fruits and available containers
for _,fruit in pairs(tf_recipes.fruits) do
    if minetest.registered_items[fruit[4]] then
        if tf_recipes.bucket ~= nil then
            table.insert(recipes,{fruit[4]..' 16',tf_recipes.bucket,"technic_farming:bucket_must_"..fruit[1],12})
        end
        if tf_recipes.bottle ~= nil then
            table.insert(recipes,{fruit[4]..' 4',tf_recipes.bottle,"technic_farming:bottle_must_"..fruit[1],4})
        end
        if tf_recipes.glass ~= nil then
            table.insert(recipes,{fruit[4]..' 1',tf_recipes.glass,"technic_farming:glas_must_"..fruit[1],1})
        end
    end
end

-- register recipes
for _, data in pairs(recipes) do
    local alloy_time = data[4] or 1
    local b_registered = true
    for i=1,3 do
        if data[i] then
            local item_name = string.split(data[i],' ')[1]
            b_registered = b_registered and (minetest.registered_items[item_name] ~= nil)
        else
            print(dump(data))
            b_registered = false
        end
    end
    if b_registered then
    	technic_farming.register_juicing_recipe({input = {data[1], data[2]}, output = data[3], time = data[4]})
    end
end
