local S = minetest.get_translator("default")

minetest.register_craftitem("tf_recipes:grain_milk", {
	description = S("Grain milk"),
	inventory_image = "tf_recipes_grain_milk.png",
	groups = {vessel = 1, drink = 1, food_milk=1},
	on_use = minetest.item_eat(2, "vessels:drinking_glass"),
})

minetest.register_craftitem("tf_recipes:frozen_coffee", {
	description = S("Frozen Coffee"),
	inventory_image = "tf_recipes_frozen_coffee.png",
	groups = {vessel = 1, drink = 1, food_milk=1},
	on_use = minetest.item_eat(3, "vessels:drinking_glass"),
})

for _,fruit in pairs(tf_recipes.fruits) do
    if tf_recipes.bucket ~= nil then
        minetest.register_node(":technic_farming:bucket_must_"..fruit[1],{
            description = S("Bucket of "..fruit[2].." must"),
            inventory_image = 'bucket.png^(batteries_bucket_contents.png^[colorize:'..fruit[3]..':200)',
            wield_image = 'bucket.png^(batteries_bucket_contents.png^[colorize:'..fruit[3]..':200)',
            tiles = {'bucket.png^(batteries_bucket_contents.png^[colorize:'..fruit[3]..':200)'},
            paramtype = "light",
            is_ground_content = false,
            walkable = false,
            groups = {vessel=1,dig_immediate=3,attached_node=1, must = 1},
            })

        minetest.register_node(":technic_farming:bucket_vinegar_"..fruit[1],{
            description = S("Bucket of "..fruit[2].." vinegar"),
            inventory_image = 'bucket.png^(batteries_bucket_contents.png^[colorize:'..fruit[3]..':100)',
            wield_image = 'bucket.png^(batteries_bucket_contents.png^[colorize:'..fruit[3]..':100)',
            tiles = {'bucket.png^(batteries_bucket_contents.png^[colorize:'..fruit[3]..':100)'},
            paramtype = "light",
            is_ground_content = false,
            walkable = false,
            groups = {vessel=1,dig_immediate=3,attached_node=1, vinegar = 1},
            })
    end
    if tf_recipes.bottle ~= nil then
        minetest.register_node(":technic_farming:bottle_must_"..fruit[1],{
            description = S("Bottle of "..fruit[2].." must"),
            inventory_image = 'batteries_bottle_contents.png^[colorize:'..fruit[3]..':200',
            wield_image = 'batteries_bottle_contents.png^[colorize:'..fruit[3]..':200',
            tiles = {'batteries_bottle_contents.png^[colorize:'..fruit[3]..':200'},
            paramtype = "light",
            is_ground_content = false,
            walkable = false,
            groups = {vessel=1,dig_immediate=3,attached_node=1, must = 1},
            })
    end
    if tf_recipes.glass ~= nil then
        minetest.register_node(":technic_farming:glass_must_"..fruit[1],{
            description = S("Glass of "..fruit[2].." must"),
            inventory_image = 'batteries_glass_contents.png^[colorize:'..fruit[3]..':200',
            wield_image = 'batteries_glass_contents.png^[colorize:'..fruit[3]..':200',
            tiles = {'batteries_glass_contents.png^[colorize:'..fruit[3]..':200'},
            paramtype = "light",
            is_ground_content = false,
            walkable = false,
            groups = {vessel=1,dig_immediate=3,attached_node=1, must = 1},
            })
    end
end

