local S = minetest.get_translator("default")

local recipes = {
	{"farming:wheat 3",  "farming:flour", 6},
	{"farming:barley 3",  "farming:flour", 6},
	{"farming:rye 3",  "farming:flour", 6},
	{"farming:oat 3",  "farming:flour", 6},
	{"farming:rice 3",  "farming:rice_flour", 6},
	{"farming:chili_pepper",  "farming:chili_powder", 6},
}

for _, data in pairs(recipes) do
    local grinder_time = data[3] or 1
    local b_registered = true
    for i=1,2 do
        local item_name = string.split(data[i],' ')[1]
        local mod_name = string.split(item_name,':')[1]
        
        b_registered = b_registered and ((minetest.registered_items[item_name] ~= nil) or (mod_name == 'group'))
    end
    if b_registered then
    	technic.register_grinder_recipe({input = {data[1]}, output = data[2], time = grinder_time})
    end
end

for itemname, idemdefinition in pairs(minetest.registered_items) do
	if idemdefinition.groups.seed == 1 then
    	technic.register_grinder_recipe({input = {itemname.." 2"}, output = "basic_materials:oil_extract", time = 6})
	end
	if idemdefinition.groups.leaves then
    	technic.register_grinder_recipe({input = {itemname.." 3"}, output = "basic_materials:oil_extract", time = 6})
	end
end
