local S = minetest.get_translator("default")
-- cup of cocoa
minetest.register_node("tf_recipes:cocoa_cup", {
	description = S("Cup of Cocoa"),
	drawtype = "torchlike",
	tiles = {"farming_coffee_cup.png"},
	inventory_image = "farming_coffee_cup.png",
	wield_image = "farming_coffee_cup.png",
	paramtype = "light",
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-0.25, -0.5, -0.25, 0.25, 0.25, 0.25}
	},
	groups = {vessel = 1, dig_immediate = 3, attached_node = 1, drink = 1},
	on_use = minetest.item_eat(2, "vessels:drinking_glass"),
	sounds = default.node_sound_glass_defaults()
})

minetest.register_node("tf_recipes:hot_lemon", {
	description = S("Hot lemon"),
	drawtype = "torchlike",
	tiles = {"tf_coffee_hot_lemon.png"},
	inventory_image = "tf_coffee_hot_lemon.png",
	wield_image = "tf_coffee_hot_lemon.png",
	paramtype = "light",
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-0.25, -0.5, -0.25, 0.25, 0.25, 0.25}
	},
	groups = {vessel = 1, dig_immediate = 3, attached_node = 1, drink = 1},
	on_use = minetest.item_eat(2, "vessels:drinking_glass"),
	sounds = default.node_sound_glass_defaults()
})

minetest.register_node("tf_recipes:cappuccino", {
	description = S("Cappuccino"),
	drawtype = "torchlike",
	tiles = {"tf_coffee_cappuccino.png"},
	inventory_image = "tf_coffee_cappuccino.png",
	wield_image = "tf_coffee_cappuccino.png",
	paramtype = "light",
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-0.25, -0.5, -0.25, 0.25, 0.25, 0.25}
	},
	groups = {vessel = 1, dig_immediate = 3, attached_node = 1, drink = 1},
	on_use = minetest.item_eat(3, "vessels:drinking_glass"),
	sounds = default.node_sound_glass_defaults()
})
