local S = minetest.get_translator("default")

technic_farming.full_flow = 120


local defaultfurnace = minetest.registered_items["default:furnace"]
--print(dump(defaultfurnace.can_dig))

function technic_farming.can_dig(pos, player)
	local meta = minetest.get_meta(pos);
	local inv = meta:get_inventory()
	return inv:is_empty("dst") and inv:is_empty("src")
end

function technic_farming.allow_metadata_inventory_put(pos, listname, index, stack, player)
	if minetest.is_protected(pos, player:get_player_name()) then
		return 0
	end
	local meta = minetest.get_meta(pos)
	local inv = meta:get_inventory()
	if listname == "src" then
		return stack:get_count()
	elseif listname == "dst" then
		return 0
	end
end

function technic_farming.allow_metadata_inventory_move(pos, from_list, from_index, to_list, to_index, count, player)
	local meta = minetest.get_meta(pos)
	local inv = meta:get_inventory()
	local stack = inv:get_stack(from_list, from_index)
	return technic_farming.allow_metadata_inventory_put(pos, to_list, to_index, stack, player)
end

function technic_farming.allow_metadata_inventory_take(pos, listname, index, stack, player)
	if minetest.is_protected(pos, player:get_player_name()) then
		return 0
	end
	return stack:get_count()
end

function technic_farming.swap_node(pos, name)
	local node = minetest.get_node(pos)
	if node.name ~= name then
		node.name = name
		minetest.swap_node(pos, node)
	end
end

function technic_farming.check_node_around_mill(pos)
	local node = minetest.get_node(pos)
	if node.name == "default:water_flowing"
	  or node.name == "default:river_water_flowing" then
		return node.param2 or 0-- returns approx. water flow, if any
	end
	return 0
end

function technic_farming.check_node_around_windmill(pos)
	local node = minetest.get_node(pos)
	if node.name == "air" then
		return math.random(5,12)-- returns approx. air flow, if air node
	end
	return 0
end

function technic_farming.get_water_flow(pos)
	local pos_lower = {x=pos.x, y=pos.y-1, z=pos.z} -- get position directly under the machine
	local node_lower = minetest.get_node(pos_lower)

	local water_flow = 0
	if node_lower.name == "technic_farming:mp_water_mill" then
		local metawatermill = minetest.get_meta(pos_lower)

		local positions = {
			{x=pos_lower.x+1, y=pos_lower.y, z=pos_lower.z},
			{x=pos_lower.x-1, y=pos_lower.y, z=pos_lower.z},
			{x=pos_lower.x,   y=pos_lower.y, z=pos_lower.z+1},
			{x=pos_lower.x,   y=pos_lower.y, z=pos_lower.z-1},
		}
		for _, p in pairs(positions) do
			water_flow = water_flow + technic_farming.check_node_around_mill(p)
		end

		water_flow = math.min(4 * water_flow, technic_farming.full_flow)
		local infotext = S("water mill inactive")
		if water_flow > 0 then
			infotext = S("water mill active")
		end
		infotext = infotext .. "\n" .. S("(Power: @1)", water_flow)
		metawatermill:set_int("mp_water_power",water_flow)
		metawatermill:set_string("infotext", infotext)
	end
	return water_flow
end

function technic_farming.get_air_flow(pos)
	local pos_upper = {x=pos.x, y=pos.y+1, z=pos.z}
	local node_upper = minetest.get_node(pos_upper)

	local air_flow = 0
	if node_upper.name == "technic_farming:mp_wind_mill" then
		local metawindmill = minetest.get_meta(pos_upper)

		local positions = {
			{x=pos.x+1, y=pos.y+1, z=pos.z},
			{x=pos.x-1, y=pos.y+1, z=pos.z},
			{x=pos.x+1, y=pos.y+1, z=pos.z+1},
			{x=pos.x-1, y=pos.y+1, z=pos.z+1},
			{x=pos.x+1, y=pos.y+1, z=pos.z-1},
			{x=pos.x-1, y=pos.y+1, z=pos.z-1},
			{x=pos.x,   y=pos.y+1, z=pos.z+1},
			{x=pos.x,   y=pos.y+1, z=pos.z-1},
		}
		for _, p in pairs(positions) do
			air_flow = air_flow + technic_farming.check_node_around_windmill(p)
		end

		air_flow = math.min(4 * air_flow, technic_farming.full_flow)
		local infotext = S("wind mill inactive")
		if air_flow > 0 then
			infotext = S("wind mill active")
		end
		infotext = infotext .. "\n" .. S("(Power: @1)", air_flow)
		metawindmill:set_int("mp_wind_power",air_flow)
		metawindmill:set_string("infotext", infotext)
	end
	return air_flow
end
