treasures.has_value = function(tab, val)
    -- test if val is in tab
        for index, value in ipairs(tab) do
            if value == val then
                return true
            end
        end
        return false
    end

local has_value=treasures.has_value

-- function to read settingtypes.txt and insert values into minetest.setting
treasures.import_settingtype = function(infile)
	local file = io.open(infile, "r")
	local outdata = {}
	-- reading header with column names
	local splitchar=" "
	local setname=minetest.settings:get_names()
	for line in file:lines() do
		if line:sub(1,1) ~= "#" then -- lines starting with # are handled as comment
			local attrib = line:gsub("\"",""):gsub("%(.*%) ",""):gsub("\r",""):split(splitchar,true)
			if(#attrib >= 3) then -- there should be at least 3 fields in a row (without the description)
				if has_value(setname,attrib[1]) == false then
					if attrib[2] == "bool" then
						minetest.settings:set_bool(attrib[1],attrib[3] == "true")
					else
						minetest.settings:set(attrib[1],attrib[3])
					end
				end
			end
		end
	end
end

treasures.update_treasure=function(name,tdef)
	if minetest.registered_items[name] == nil then
		treasures.add_treasure(name,tdef)
	else
		minetest.override_item(name,tdef)
	end
end

treasures.map_treasure=function(name,tdef)
	if tdef == nil then return end
	if minetest.registered_items[name] == nil then 
		print(name.." not yet registered")
		treasures.add_treasure(name,M.treasure_default)
	end
	for i,attr in ipairs({"ore_type","wherein","clust_scarcity","clust_num_ores","clust_size","y_min","y_max"}) do
		if tdef[attr]==nil then
			tdef[attr]=treasures.map_def[attr]
		end
	end
	if tdef.ore == nil then tdef.ore=name end
	minetest.register_ore(tdef)
end

treasures.add_treasure=function(name,tdef)
	if tdef.tiles == nil then
		return
	end
	if minetest.registered_items[name] ~= nil then
		minetest.override_item(name,tdef)
	else
		for i,attr in ipairs({"is_ground_content","groups","sounds","drop"}) do
			if tdef[attr]==nil then
				tdef[attr]=treasures.treasure_default[attr]
			end
		end
		if tdef.description==nil then
			tdef.despricption=name
		end
		minetest.register_node(name, tdef)
	end
end

treasures.add_drop=function(name,drop_def)
	if drop_def.items == nil then
		return
	end
	local add_item = drop_def.items
	if add_item[1] ~= nil then
		add_item=add_item[1]
	end
	if minetest.registered_items[add_item:split(" ")[1]] == nil then
		return
	end
	if drop_def.rarety == nil then
		drop_def.rarety = 20
	end
	if minetest.registered_items[name] == nil then
		local tdef={	
			drop = {
				max_items = 5,
				items = {drop_def}
				}}
        treasures.add_treasure(name,tdef)
	else
		local tdef={}
		tdef=table.copy(minetest.registered_items[name])
		table.insert(tdef.drop.items,math.random(1,#tdef.drop.items),drop_def)
		minetest.register_node(":"..name,tdef)
	end

end

treasures.register_ore=function(tdef)
	for i,attr in pairs(M.map_def) do
		if tdef[i] == nil then
			tdef[i]= attr
		end
	end
	minetest.register_ore(tdef)
	
end

treasures.add_register_treasure=function(name,tdef,mapdef)
	treasures.add_treasure(name,tdef)
	treasures.register_ore(mapdef)
end
