local mpath = core.get_modpath("super_axe")

local toolNames = {
	wood = "Wood",
	stone = "Stone",
	bronze = "Bronze",
	steel = "Steel",
	mese = "Mese",
	diamond = "Diamond",
}

local function mkSuperTool(name)
	local old_axe_def = core.registered_items["default:axe_" .. name]

	local super_axe_def = {
		description = "A Super " .. toolNames[name] .. " Axe\n(Attempts to chop the whole tree)",
		short_description = "A Super " .. toolNames[name] .. " Axe",
		inventory_overlay = "super_axe_overlay.png",
		after_use = function (...)
			return super_axe.dig(...)
		end,
	}

	local final_axe_def = {}
	for key, value in pairs(old_axe_def) do
		final_axe_def[key] = value
	end
	for key, value in pairs(super_axe_def) do
		final_axe_def[key] = value
	end

	core.register_tool("super_axe:axe_" .. name, final_axe_def)
end

for name, _ in pairs(toolNames) do
	mkSuperTool(name)

	core.register_craft({
		type = "shapeless",
		output = "super_axe:axe_" .. name,
		recipe = {
			"default:axe_" .. name,
			"astralcraft:star_fragment",
		},
	})
end

core.register_on_punchnode(function (...)
	return super_axe.punch(...)
end)

core.register_on_craft(function (...)
	return super_axe.craft(...)
end)
