local function dump(thing, levels)
	local out = ""
	local first = true
	for key, value in pairs(thing) do
		if first then
			first = false
		else
			out = out .. "\n"
		end
		out = out .. key .. "\t-> " .. tostring(value)
	end
	return out
end

local function xyzKey(pos)
	return string.format("%d:%d:%d", pos.x, pos.y, pos.z)
end

local function collectNodes(targetName, sp)
	local key = xyzKey(sp)
	local visited = {[key] = true}
	local accum = {sp}
	local topAccum = 1

	local function visitNode(c, dx, dy, dz)
		if c.y > sp.y or dy >= 0 then
			local np = { x = c.x + dx, y = c.y + dy, z = c.z + dz }
			local npk = xyzKey(np)
			if visited[npk] then return end

			local node = core.get_node(np)
			if node.name == targetName then
				accum[#accum + 1] = np
				visited[npk] = true
			end
		end
	end

	while topAccum <= #accum do
		local c = accum[topAccum]

		visitNode(c,  0, -1,  0)

		visitNode(c, -1, -1,  0)
		visitNode(c, -1, -1, -1)
		visitNode(c,  0, -1, -1)
		visitNode(c,  1, -1, -1)
		visitNode(c,  1, -1,  0)
		visitNode(c,  1, -1,  1)
		visitNode(c,  0, -1,  1)
		visitNode(c, -1, -1,  1)

		visitNode(c, -1,  0,  0)
		visitNode(c, -1,  0, -1)
		visitNode(c,  0,  0, -1)
		visitNode(c,  1,  0, -1)
		visitNode(c,  1,  0,  0)
		visitNode(c,  1,  0,  1)
		visitNode(c,  0,  0,  1)
		visitNode(c, -1,  0,  1)

		visitNode(c,  0,  1,  0)

		visitNode(c, -1,  1,  0)
		visitNode(c, -1,  1, -1)
		visitNode(c,  0,  1, -1)
		visitNode(c,  1,  1, -1)
		visitNode(c,  1,  1,  0)
		visitNode(c,  1,  1,  1)
		visitNode(c,  0,  1,  1)
		visitNode(c, -1,  1,  1)

		topAccum = topAccum + 1
	end

	return accum
end

local diggingNodes = {}
local function punch(pos, node, user, pointedThing)
	if not (user and user:is_player()) then return end

	diggingNodes[user:get_player_name()] = pos
end

local function dig(itemstack, user, node, digparams)
	local targetName = node.name
	if core.get_node_group(targetName, "tree") == 0 then
        itemstack:add_wear(digparams.wear)
		return itemstack
	end

	if not (user and user:is_player()) then return end

	local playerName = user:get_player_name()
	local pos = diggingNodes[playerName]
	if pos then
		local wear = digparams.wear

		local collected = collectNodes(targetName, pos)

		while #collected > 1 and not itemstack:is_empty() do
			local npos = table.remove(collected)
			core.set_node(npos, {name = "air"})
			core.add_item(user:get_pos(), targetName)
			itemstack:add_wear(wear)
		end
		if #collected > 1 then
			core.set_node(pos, {name = targetName})
		end

		diggingNodes[playerName] = nil
	else
		core.chat_send_all("Warning!  No diggingNode...")
	end

	return itemstack
end

local function craft(itemstack, player, oldCraftGrid, craftInv)
	local axeWear = 0

	for _, stack in ipairs(oldCraftGrid) do
		if stack:get_name():sub(1, 12) == "default:axe_" then
			axeWear = stack:get_wear()
		end
	end

	itemstack:set_wear(axeWear)
end

function super_axe.punch(pos, node, puncher, pointed_thing)
	local ok, value = pcall(punch, pos, node, puncher, pointed_thing)
	if not ok then
		core.chat_send_all("Error punching: " .. value)
		return
	end
end

function super_axe.dig(itemstack, user, node, digparams)
	local ok, value = pcall(dig, itemstack, user, node, digparams)
	if not ok then
		core.chat_send_all("Error: " .. value)
		return
	end
	return value
end

function super_axe.craft(itemstack, player, old_craft_grid, craft_inv)
	local ok, value = pcall(craft, itemstack, player, old_craft_grid, craft_inv)
	if not ok then
		core.chat_send_all("Error crafting: " .. value)
		return
	end
	return value
end
