-- vim: ts=4 sw=4 noet
local S = minetest.get_translator "advtrains_subway_ny"

local SND_LOOP_LEN = 15
local enginesound = "ny_subway_throttle"
local hornsound = "whistle_16"
local idlesound = "electric_idle"

local use_attachment_patch =
	minetest.get_modpath("advtrains_attachment_offset_patch")
	and advtrains_attachment_offset_patch.setup_advtrains_wagon

local view_offset = use_attachment_patch
	and {x = 0, y = 0, z = 0}
	or {x = 0, y = 0.5, z = 0} --adjust

local vo = -1 --wagonseats


local ny_subway_engine = {
	mesh = "advtrains_engine_ny.b3d",
	textures = {"advtrains_engine_ny.png"},
	is_locomotive = true,
	drives_on = {default = true},
	max_speed = 15,
	seats = {
		{
			name = "DriverStand",
			attach_offset = use_attachment_patch and {x = 0, y = 0.25, z = 19.0} or {x = 0, y = -3, z = 17},
			view_offset = use_attachment_patch and {x = 0, y = -3.0, z = 0} or {x = 0, y = -3, z = 10},
			driving_ctrl_access = true,
			group = "dstand",
			anim = "stand",
			visual_scale = 0.8
		},
		{
			name = "1",
			attach_offset = use_attachment_patch and {x = -5, y = 3.5, z = 5.75} or {x = -3, y = 0, z = 7},
			view_offset = use_attachment_patch and {x = 0, y = vo, z = 0} or {x = -3, y = -4, z = 7},
			advtrains_attachment_offset_patch_attach_rotation = use_attachment_patch and {x = 0, y = 90, z = 0} or nil,
			group = "pass1",
			anim = "sit",
			visual_scale = 0.8
		},
		{
			name = "2",
			attach_offset = use_attachment_patch and {x = 5, y = 3.5, z = -5.75} or {x = 3, y = 0, z = 7},
			view_offset = use_attachment_patch and {x = 0, y = vo, z = 0} or {x = 3, y = -4, z = 7},
			advtrains_attachment_offset_patch_attach_rotation = use_attachment_patch and {x = 0, y = -90, z = 0} or nil,
			group = "pass2",
			anim = "sit",
			visual_scale = 0.8
		},
		{
			name = "3",
			attach_offset = use_attachment_patch and {x = -1, y = 0, z = -15} or {x = -3, y = 0, z = -7},
			view_offset = use_attachment_patch and {x = 0, y = -3.0, z = 0} or {x = -3, y = -4, z = -7},
			advtrains_attachment_offset_patch_attach_rotation = use_attachment_patch and {x = 0, y = 90, z = 0} or nil,
			group = "pass3",
			anim = "stand",
			visual_scale = 0.8
		},
		{
			name = "4",
			attach_offset = use_attachment_patch and {x = 1, y = 0, z = 15} or {x = 3, y = 0, z = -7},
			view_offset = use_attachment_patch and {x = 0, y = -3.0, z = 0} or {x = 3, y = -4, z = -7},
			advtrains_attachment_offset_patch_attach_rotation = use_attachment_patch and {x = 0, y = -90, z = 0} or nil,
			group = "pass4",
			anim = "stand",
			visual_scale = 0.8
		},
	},
	seat_groups = {
		dstand = {
			name = S("Driver Stand"),
			access_to = {"pass1", "pass2", "pass3", "pass4"},
			driving_ctrl_access = true,
			require_doors_open = true,
		},
		pass1 = {
 			name = S("Seat One"),
			access_to = {"pass2", "pass3", "pass4", "dstand"},
			require_doors_open = false,
		},
		pass2 = {
			name = S("Seat Two"),
			access_to = {"pass1", "pass3", "pass4", "dstand"},
			require_doors_open = false,
		},

		pass3={
			name = S("Seat Three"),
			access_to = {"pass1", "pass2", "pass4", "dstand"},
			require_doors_open = false,
		},
		pass4={
			name = S("Seat Four"),
			access_to = {"pass1", "pass2", "pass3", "dstand"},
			require_doors_open = false,
		},

	},
	assign_to_seat_group = {"dstand", "pass1", "pass2", "pass3", "pass4"},
	doors = {
		open = {
			[1] = {frames = {x = 0, y = 10}, time = 1}, --closed 1, 20, 40
			[-1] = {frames = {x = 20, y = 30}, time = 1} --open 10, 30
		},
		close = {
			[1] = {frames={x = 10, y = 20}, time = 1},
			[-1] = {frames={x = 30, y = 40}, time = 1}
		}
	},
	visual_size = {x = 1, y = 1},
	wagon_span = 2.3,
	collisionbox = {-1.0, -0.5, -1.0,  1.0, 2.5, 1.0},
	drops = {"advtrains:NY_lokomotive"},
	horn_sound = hornsound,
	
	custom_on_velocity_change = function(self, velocity, old_velocity, dtime)
        if not velocity or not old_velocity then return end
        if old_velocity == 0 and velocity > 0 then
            minetest.sound_play("ny_subway_throttle", {object = self.object})
        end

		if self.old_anim_velocity~=advtrains.abs_ceil(velocity) then
			if advtrains.wagons[self.id].wagon_flipped then
			self.object:set_animation({x = 50, y = 130}, -(advtrains.abs_ceil(velocity)*15), 0, true)
			else
			self.object:set_animation({x = 50, y = 130},   advtrains.abs_ceil(velocity)*15, 0, true)
			end
		self.old_anim_velocity = advtrains.abs_ceil(velocity)
		end
	end,
	
}

local ny_subway_wagon = {
	mesh = "advtrains_wagon_ny.b3d",
	textures = {"advtrains_engine_ny.png"},
	drives_on = {default = true},
	max_speed = 15,
	seats = {
		{
			name = "1",
			attach_offset = use_attachment_patch and {x = -5, y = 3.5, z = 5.75} or {x = -3, y = 0, z = 7},
			view_offset = use_attachment_patch and {x = 0, y = vo, z = 0} or {x = -3, y = -4, z = 7},
			advtrains_attachment_offset_patch_attach_rotation = use_attachment_patch and {x = 0, y = 90, z = 0} or nil,
			group = "pass1",
			anim = "sit",
			visual_scale = 0.8
		},
		{
			name = "2",
			attach_offset = use_attachment_patch and {x = 5, y = 3.5, z = -5.75} or {x = 3, y = 0, z = 7},
			view_offset = use_attachment_patch and {x = 0, y = vo, z = 0} or {x = 3, y = -4, z = 7},
			advtrains_attachment_offset_patch_attach_rotation = use_attachment_patch and {x = 0, y = -90, z = 0} or nil,
			group = "pass2",
			anim = "sit",
			visual_scale = 0.8
		},
		{
			name = "3",
			attach_offset = use_attachment_patch and {x = -1, y = 0, z = -15} or {x = -3, y = 0, z = -7},
			view_offset = use_attachment_patch and {x = 0, y = -3.0, z = 0} or {x = -3, y = -4, z = -7},
			advtrains_attachment_offset_patch_attach_rotation = use_attachment_patch and {x = 0, y = 90, z = 0} or nil,
			group = "pass3",
			anim = "stand",
			visual_scale = 0.8
		},
		{
			name = "4",
			attach_offset = use_attachment_patch and {x = 1, y = 0, z = 15} or {x = 3, y = 0, z = -7},
			view_offset = use_attachment_patch and {x = 0, y = -3.0, z = 0} or {x = 3, y = -4, z = -7},
			advtrains_attachment_offset_patch_attach_rotation = use_attachment_patch and {x = 0, y = -90, z = 0} or nil,
			group = "pass4",
			anim = "stand",
			visual_scale = 0.8
		},
	},
	seat_groups = {
		pass1 = {
			name = S("Seat One"),
			access_to = {"pass2", "pass3", "pass4"},
			require_doors_open = false,
		},
		pass2 = {
			name = S("Seat Two"),
			access_to = {"pass1", "pass3", "pass4"},
			require_doors_open = false,
		},
		pass3 = {
			name = S("Seat Three"),
			access_to = {"pass1", "pass2", "pass4"},
			require_doors_open = false,
		},
		pass4 = {
			name = S("Seat Four"),
			access_to = {"pass1", "pass2", "pass3"},
			require_doors_open = false,
		},
	},
	assign_to_seat_group = {"pass1", "pass2", "pass3", "pass4"},
	doors = {
		open = {
			[1]={frames={x = 0, y = 10}, time = 1}, -- closed 1, 20, 40
			[-1]={frames={x = 20, y = 30}, time = 1} -- open 10, 30
		},
		close = {
			[1]={frames={x = 10, y = 20}, time = 1},
			[-1]={frames={x = 30, y = 40}, time = 1}
		}
	},
	door_entry = {-1, 1},
	visual_size = {x = 1, y = 1},
	wagon_span = 2.3,
	collisionbox = {-1.0,-0.5,-1.0, 1.0,2.5,1.0},
	drops = {"advtrains:ny_wagon"},

    custom_on_velocity_change = function(self, velocity)
		if self.old_anim_velocity ~= advtrains.abs_ceil(velocity) then
			if advtrains.wagons[self.id].wagon_flipped then
                self.object:set_animation({x = 50, y = 130}, -(advtrains.abs_ceil(velocity)*15), 0, true) --wheels
			else
                self.object:set_animation({x = 50, y = 130},   advtrains.abs_ceil(velocity)*15, 0, true)
			end
		self.old_anim_velocity = advtrains.abs_ceil(velocity)
		end
	end,
}


if use_attachment_patch then
    advtrains_attachment_offset_patch.setup_advtrains_wagon(ny_subway_engine)
    advtrains_attachment_offset_patch.setup_advtrains_wagon(ny_subway_wagon)
end

advtrains.register_wagon("NY_lokomotive", ny_subway_engine,
    S("NY Subway Engine"), "advtrains_engine_ny_inv.png")

advtrains.register_wagon("ny_wagon", ny_subway_wagon,
    S("NY Subway Wagon"), "advtrains_wagon_ny_inv.png")

minetest.register_craft({
	output = 'advtrains:NY_lokomotive',
	recipe = {
		{'default:steelblock', 'default:steelblock', 'default:steelblock'},
		{'default:glass', 'default:steelblock', 'default:glass'},
		{'advtrains:wheel', 'advtrains:wheel', 'advtrains:wheel'},
	},
})

minetest.register_craft({
	output = 'advtrains:ny_wagon',
	recipe = {
		{'default:steelblock', 'default:steelblock', 'default:steelblock'},
		{'default:glass', 'default:glass', 'default:glass'},
		{'advtrains:wheel', 'advtrains:wheel', 'advtrains:wheel'},
	},
})