# Japanese Tram TLR0600
## by takaosan

![](screenshot.png)

This mod is an extension for Advtrains that provides the front and rear units of a light rail tram inspired by the Japanese TLR0600 from Toyama. The tram features a modern exterior and has a detailed interior and would look good in most modern urban settings.

The current version of this mod includes a generic matched pair of front and rear units. If this mod is used with the optional [AdvTrains Livery Tools](https://content.minetest.net/packages/Marnack/advtrains_livery_tools/) modpack, players will be able to customize the livery of these trams in game by using the Livery Designer Tool.

This mod also still includes the now deprecated original four matched pairs of front and back units in blue, green, red and yellow. They are not available by default but can be enabled via the "Include deprecated trams" mod setting (default = Disabled).  Unless playing in an existing game which used an earlier version of this mod or in a game that is not using the AdvTrains Livery Tools mod, these deprecated wagons should not be needed since they can be easily replicated with the livery tool.

The following livery templates are currently defined for the trams in this mod:

* 	"Toyama" - This template can be used to replicate the livery style of the deprecated units which is based on the livery of the trams in Toyama, Japan. It allows for customization of the service color surrounding the doorways and in various windows as well as the exterior walls, window trim and seats.
* 	"Ribbon" - An optional multicolored ribbon meanders around the exterior of the unit. It can be colored to match the service line if desired. The exterior walls, window trim and seats can also be customized.
* 	"Upper-Lower Split" - This template allows for different colors to be applied to the upper and lower portions of the exterior walls as well as an optional service color stripe. The window trim and seats can also be customized.

Several predefined liveries based on these templates are also available in the livery tool, including four predefined liveries that replicate the deprecated trams.

Note that the livery tool will open and display information for the deprecated units but there are no livery customization options or predefined liveries for these units. Thus, it will only allow the player to view but not modify these older wagons.

The new generic tram units will have crafting recipes when this mod is used along with with the default mod from Minetest Game. As it was in earlier versions of this mod, the deprecated trams have no crafting recipes so players will need to use the /give or /giveme command to acquire these units when playing in survival mode.

This mod features a system that updates the appearance of the trams such that they appear to be realistically illuminated at night. Since the system is only based on the time of day, however, it has some limitations, such as the illumination effect not being applied if a tram is located in a darkened area such as a tunnel during the daytime. This feature can be disabled via the "Use illuminated appearance of trams during the night" mod setting (default = Enabled).

The driver's stand is accessed in the front unit which is the one without the pantograph on its roof.

These units have sounds but not animated doors.

### Download
* Current version: https://codeberg.org/advtrains_supplemental/advtrains_train_jpntlr600
* Original version: https://github.com/takao-soramu/advtrains_train_jpntlr600

### Installation
 * Extract .zip contents to: [path to minetest folder]/mods/advtrains_train_jpntlr60
 * Sample textures have been provided for future reference: ./sample_textures

### Licence
* License of code: GNU AGPL version 3 (see License.txt)
* License of media: CC-BY-SA 3.0 (see LICENSE_media.txt)

The following copyrights apply:
* Original code and assets copyright (C) 2020 takaosan
* Some code copyright (C) 2020 Maverick2797
* Some code copyright (C) 2022 W3RQ01
* Some code and assets copyright (C) 2023 Marnack

### Credits
* Original Author: Takaosan
* Contributions by Maverick2797
	* Tidy code
* Contributions by W3RQ01
	* Update max speed
* Contributions by Marnack
	* Add mod setting to control illuminated appearance of trams
	* Improve activation timing of illumination effect
	* Add a new generic version of the TLR0600 tram pair that can be modified with the livery designer tool from the optional AdvTrains Livery Tools modpack.
	* Deprecate the original 4 pairs of trams that have preset colors and add a mod setting to control if they should be included in the game.
	* Generalize the nighttime illuminated tram effect to also apply to the new generic TLR0600 trams, including those with customized liveries.
	* Add crafting recipes for the generic TLR0600 trams when this mod used with Minetest Game.

### More Information
* See https://advtrains.de/ for more information about Advtrains

Use of this mod is at your own risk. The author and contributors can not be held liable or responsible for any damages caused by using any part of this mod.


このModは、Minetest向けADVTRAINS Modのアドオンデータです。これ単体では利用できません

このModで生じたいかなる損害も、製作者は一切の責任を負いません

ADVTRAINS Modのライセンスを継承します
