minetest.register_craftitem("quartz_new:quartz_crystal", {
    description = "Quartz Crystal",
    inventory_image = "quartz_crystal.png",
})

minetest.register_node("quartz_new:quartz_ore", {
    description = "Quartz Ore",
    tiles = {"default_desert_stone.png^quartz_mineral.png"},
    drop = "quartz_new:quartz_crystal",
    groups = {cracky=3},
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_ore({
    ore_type = "scatter",
    ore = "quartz_new:quartz_ore",
    wherein = "default:desert_stone",
    clust_scarcity = 9*9*9,
    clust_num_ores = 4,
    clust_size = 3,
    y_min = 1,
    y_max = 31000,
})

minetest.register_ore({
    ore_type = "scatter",
    ore = "quartz_new:quartz_ore",
    wherein = "default:desert_stone",
    clust_scarcity = 8*8*8,
    clust_num_ores = 7,
    clust_size = 4,
    y_min = -64,
    y_max = 0,
})

minetest.register_ore({
    ore_type = "scatter",
    ore = "quartz_new:quartz_ore",
    wherein = "default:desert_stone",
    clust_scarcity = 7*7*7,
    clust_num_ores = 11,
    clust_size = 4,
    y_min = -31000,
    y_max = -64,
})

minetest.register_node("quartz_new:quartz", {
    description = "Quartz",
    tiles = {"quartz.png"},
    paramtype = "light",
    groups = {cracky=3},
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("quartz_new:quartz_block", {
    description = "Quartz Block",
    tiles = {"quartz_block.png"},
    paramtype = "light",
    groups = {cracky=3},
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("quartz_new:quartz_brick", {
    description = "Quartz Brick",
    tiles = {"quartz_brick.png"},
    paramtype = "light",
    groups = {cracky=3},
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
    output = "quartz_new:quartz",
    recipe = {
        {"quartz_new:quartz_crystal", "quartz_new:quartz_crystal", "quartz_new:quartz_crystal"},
        {"quartz_new:quartz_crystal", "quartz_new:quartz_crystal", "quartz_new:quartz_crystal"},
        {"quartz_new:quartz_crystal", "quartz_new:quartz_crystal", "quartz_new:quartz_crystal"},
    },
})

minetest.register_craft({
    output = "quartz_new:quartz_block 9",
    recipe = {
        {"quartz_new:quartz", "quartz_new:quartz", "quartz_new:quartz"},
        {"quartz_new:quartz", "quartz_new:quartz", "quartz_new:quartz"},
        {"quartz_new:quartz", "quartz_new:quartz", "quartz_new:quartz"},
    },
})

minetest.register_craft({
    output = "quartz_new:quartz_crystal 9",
    recipe = {{"quartz_new:quartz"}},
})

minetest.register_craft({
    output = "quartz_new:quartz_crystal 9",
    recipe = {{"quartz_new:quartz_block"}},
})

minetest.register_craft({
    output = "quartz_new:quartz_crystal 9",
    recipe = {{"quartz_new:quartz_brick"}},
})

minetest.register_node("quartz_new:glass", {
    description = "Quartz Glass",
    tiles = {"quartz_glass.png^[opacity:85"},
    inventory_image = "[inventorycube{quartz_glass.png{quartz_glass.png{quartz_glass.png",
    drawtype = "glasslike",
    paramtype = "light",
    use_texture_alpha = "blend",
    groups = {cracky=3, quartz_glass=1},
    sounds = default.node_sound_glass_defaults(),
})

minetest.register_craft({
    type = "cooking",
    recipe = "quartz_new:quartz_crystal",
    output = "quartz_new:glass",
})

xpanes.register_pane("pane_quartz", {
    description = "Quartz Glass Pane",
    textures = {"quartz_glass.png^[opacity:85", "", "quartz_glass.png^[opacity:85"},
    inventory_image = "quartz_glass.png",
    wield_image = "quartz_glass.png",
    use_texture_alpha = "blend",
    sounds = default.node_sound_glass_defaults(),
    groups = {snappy=2, cracky=3, oddly_breakable_by_hand=3, quartz_glass_pane=1},
    recipe = {
        {"quartz_new:glass", "quartz_new:glass", "quartz_new:glass"},
        {"quartz_new:glass", "quartz_new:glass", "quartz_new:glass"}
    }
})

local colors = {
    {"white",      "White"},
    {"grey",       "Grey"},
    {"dark_grey",  "Dark Grey"},
    {"black",      "Black"},
    {"violet",     "Violet"},
    {"blue",       "Blue"},
    {"cyan",       "Cyan"},
    {"dark_green", "Dark Green"},
    {"green",      "Green"},
    {"yellow",     "Yellow"},
    {"brown",      "Brown"},
    {"orange",     "Orange"},
    {"red",        "Red"},
    {"magenta",    "Magenta"},
    {"pink",       "Pink"},
}

for _,name in ipairs(colors) do
    minetest.register_node("quartz_new:glass_"..name[1], {
        description = name[2].." Quartz Glass",
        tiles = {"quartz_glass_"..name[1]..".png^[opacity:127"},
        inventory_image = "[inventorycube{quartz_glass_"..name[1]..".png{quartz_glass_"..name[1]..".png{quartz_glass_"..name[1]..".png",
        drawtype = "glasslike",
        use_texture_alpha = "blend",
        paramtype = "light",
        sunlight_propagates = true,
        groups = {cracky = 3, quartz_glass = 1},
        sounds = default.node_sound_glass_defaults(),
    })
    
    minetest.register_craft({
        type = "shapeless",
        output = "quartz_new:glass_"..name[1],
        recipe = {"group:quartz_glass", "dye:"..name[1]},
    })
    
    xpanes.register_pane("pane_quartz_"..name[1], {
        description = name[2].." Quartz Glass Pane",
        textures = {"quartz_glass_"..name[1]..".png^[opacity:127", "", "quartz_glass_"..name[1]..".png^[opacity:127"},
        inventory_image = "quartz_glass_"..name[1]..".png",
        wield_image = "quartz_glass_"..name[1]..".png",
        use_texture_alpha = "blend",
        sounds = default.node_sound_glass_defaults(),
        groups = {snappy=2, cracky=3, oddly_breakable_by_hand=3, quartz_glass_pane=1},
        recipe = {
            {"quartz_new:glass_"..name[1], "quartz_new:glass_"..name[1], "quartz_new:glass_"..name[1]},
            {"quartz_new:glass_"..name[1], "quartz_new:glass_"..name[1], "quartz_new:glass_"..name[1]},
        }
    })
    
    minetest.register_craft({
        output = "xpanes:pane_quartz_"..name[1].."_flat",
        type = "shapeless",
        recipe = {"group:quartz_glass_pane", "dye:"..name[1]},
    })
end

if minetest.get_modpath("stairs") then
    stairs.register_stair_and_slab("quartz", "quartz_new:quartz",
    {cracky = 3},
    {"quartz.png"},
    "Quartz Stair",
    "Quartz Slab",
    default.node_sound_stone_defaults())
    
    stairs.register_stair_and_slab("quartz_block", "quartz_new:quartz_block",
    {cracky = 3},
    {"quartz_block.png"},
    "Quartz Block Stair",
    "Quartz Block Slab",
    default.node_sound_stone_defaults())
    
    stairs.register_stair_and_slab("quartz_brick", "quartz_new:quartz_brick",
    {cracky = 3},
    {"quartz_brick.png"},
    "Quartz Brick Stair",
    "Quartz Brick Slab",
    default.node_sound_stone_defaults())
end

if minetest.get_modpath("terumet") then
    terumet.register_ore_cutting("quartz_new:quartz_ore")
    
    local crys_quartz = terumet.register_crystal({
        suffix = "quartz",
        color = "#cccccc",
        name = "Crystallized Quartz",
        cooking_result = "quartz_new:quartz_crystal",
    })
    
    terumet.register_vulcan_result("quartz_new:quartz_ore", crys_quartz)
end
