Numeracy Mod for Minetest
=========================

Adds blocks for exploring numeracy with children, which join together and
change appearance depending on the number of connected blocks. Inspired by the
kids TV programme Numberblocks.

![Screenshot](docs/screenshot.jpg)

Version: 0.1

Licence: LGPL 2.1 or later, CC-BY-SA 3.0 UNPORTED (see LICENSE.txt)

Dependencies: none

Report bugs to the [github repository](https://github.com/amalon/minetest-numeracy/issues).

Request help (or report bugs) in the [Matrix room](https://matrix.to/#/#minetest-numeracy:hoganfam.uk?via=hoganfam.uk).

Installation
------------

Unzip the archive and place it in minetest/mods/minetest/

(  Linux: If you have a linux system-wide installation place
	it in ~/.minetest/mods/minetest/.  )

(  If you only want this to be used in a single world, place
	the folder in worldmods/ in your worlddirectory.  )

For further information or help see:
http://wiki.minetest.com/wiki/Installing_Mods

Getting Started
---------------

Get a "Numeracy Block" from the creative inventry and start placing them down
in groups. Watch the blocks change appearance and the number above the blocks
change.

Try measuring the distance between two places by placing a trail of blocks
down.

Try making as many different rectangles or other shapes out of the same number
of blocks.

Try exploring sequences of natural numbers, times tables (rectangles), square
numbers, cube numbers, triangle numbers (like a stair case).

Roadmap
-------

Some features I may add to this mod in future include:
 - Extend beyond 99 blocks in a group
 - Add tools to make things easier and faster, e.g.:
   - Extend the group of blocks in the chosen direction
   - Rearrange groups of blocks to explore factors and other properties
 - Selection of blocks in a group for counting or other operations, making them
   light up
 - Add some form of arithmetic operators to combine (add/multiply), split
   (subtract/divide), or otherwise manipulate (square/cube) groups of blocks
 - Sounds (reading out of numbers)
