mcl_skyblock = {}

-- TODO extra biomes

local DEFAULT_BIOME_OVERWORLD = "ExtremeHills"
local DEFAULT_BIOME_NETHER = "Nether" -- or "CrimsonForest"

local START_AREA_Y = 0

local player_start_pos = vector.new(2, START_AREA_Y, 1)

local stuff_string = "mcl_core:ice 2,mcl_buckets:bucket_lava,mcl_farming:sweet_berry,mcl_core:sapling 3,mcl_core:obsidian 10,mcl_fire:flint_and_steel,mcl_core:reeds"--,mcl_torches:torch 1

local S = minetest.get_translator(minetest.get_current_modname())

local modpath = minetest.get_modpath(minetest.get_current_modname())
local schema_path = modpath.."/schematics/main_island.mts"

local formspec = "size[6,4.5]" .. "label[1,1.25;" .. S("I wonder where you go when you die?") .. "]"
formspec = formspec .. "button_exit[1.5,2.25;3,1;close;"..S("Let's find out!") .."]"


-- ### SETUP INVENTORY ###

local function add_from_csv(str)
	local items_output = {}
	local items = str:split(",")
	for _, itemname in ipairs(items) do
		table.insert(items_output, ItemStack(itemname))
	end
	return items_output
end

local inv_table = add_from_csv(stuff_string)

local function setup_inv(player)

	local inv = player:get_inventory()
	for _, stack in ipairs(inv_table) do
		if inv:room_for_item("main", stack) then
			inv:add_item("main", stack)
		end
	end
end

-- ### SETUP PLAYER ###

local function setup_player(player)
	local player_meta = player:get_meta()
	if player_meta:get_int("mcl_skyblock:player_setup") ~= 1 then
		setup_inv(player, stuff_string);
		player:set_pos(player_start_pos)
		player_meta:set_int("mcl_skyblock:player_setup", 1)
	end
end

-- ### SETUP WORLD ###

local function place_schema_island (pos)
	minetest.place_schematic(vector.offset(pos, 0,-3,0), schema_path, "0", nil, false, "place_center_x,place_center_z")
	mcl_core.generate_oak_tree(vector.offset(pos, -2,0,3))
	minetest.set_node(vector.offset(pos, 2, 0, -2), {name = "mcl_chests:chest_small", param2=2})
end

minetest.register_chatcommand("schemago", {
	privs = { debug = false },
	func = function(name, param)
		place_schema_island (vector.new(0,START_AREA_Y,0))
	end,
})

local function setup_world(player)
	local player_meta = player:get_meta()
	if player_meta:get_int("mcl_skyblock:world_setup") ~= 1 then
		place_schema_island (vector.new(0,START_AREA_Y,0))
		player_meta:set_int("mcl_skyblock:world_setup", 1)
	end
end

local function setup(player)
	playerphysics.add_physics_factor(player, "gravity", "skyblock_start", 0)
	minetest.show_formspec("singleplayer", "start_formspec", formspec)

	minetest.after(1, function()
		setup_player(player)
		setup_world(player)
	end)

	minetest.after(2, function()
		playerphysics.remove_physics_factor(player, "gravity", "skyblock_start")
	end)
end

local mg_name = minetest.get_mapgen_setting("mg_name")
if mg_name == "singlenode" then
	mcl_mobs.register_custom_biomecheck(function(pos)
		if pos then
			if mcl_worlds.pos_to_dimension(pos) == "nether" then
				return DEFAULT_BIOME_NETHER
			else
				return DEFAULT_BIOME_OVERWORLD
			end
			return DEFAULT_BIOME_OVERWORLD
		end
	end)

	minetest.register_on_newplayer(function(player)
		setup(player)
	end)
else
	minetest.log("Incorrect mapgen set. The world needs to be created as singlenode.")
end


