function airutils.physics(self)
    local friction = 0.99
	local vel=self.object:get_velocity()
    local new_velocity = vel

	--buoyancy
	local surface = nil
	local surfnodename = nil
	local spos = airutils.get_stand_pos(self)
	spos.y = spos.y+0.01
	-- get surface height
	local snodepos = airutils.get_node_pos(spos)
	local surfnode = airutils.nodeatpos(spos)
	while surfnode and (surfnode.drawtype == 'liquid' or surfnode.drawtype == 'flowingliquid') do
		surfnodename = surfnode.name
		surface = snodepos.y +0.5
		if surface > spos.y+self.height then break end
		snodepos.y = snodepos.y+1
		surfnode = airutils.nodeatpos(snodepos)
	end

	self.isinliquid = surfnodename
	if surface then				-- standing in liquid
        self.isinliquid = true
    end

    if self.isinliquid then
        local accell = {x=0, y=0, z=0}
        self.water_drag = 0.1
        local height = self.height
		local submergence = math.min(surface-spos.y,height)/height
--		local balance = self.buoyancy*self.height
		local buoyacc = airutils.gravity*(self.buoyancy-submergence)
        --minetest.chat_send_all(buoyacc)
        accell = {x=-new_velocity.x*self.water_drag,y=buoyacc-(new_velocity.y*math.abs(new_velocity.y)*5.4),z=-new_velocity.z*self.water_drag}

        if self.buoyancy >= 1 then self._engine_running = false end
        new_velocity = vector.add(new_velocity, vector.multiply(accell, self.dtime))
	else
        airutils.set_acceleration(self.object,{x=0,y=0,z=0})
		self.isinliquid = false
        new_velocity = vector.add(new_velocity, {x=0,y=airutils.gravity * self.dtime,z=0})
	end

    if self.isonground and not self.isinliquid then
        --dumb friction
        new_velocity = {x=new_velocity.x*friction,
							    y=new_velocity.y,
							    z=new_velocity.z*friction}
        -- bounciness
        if self.springiness and self.springiness > 0 and self.buoyancy >= 1 then
            local vnew = vector.new(new_velocity)
            
            if not self.collided then						-- ugly workaround for inconsistent collisions
	            for _,k in ipairs({'y','z','x'}) do
		            if new_velocity[k]==0 and math.abs(self.lastvelocity[k])> 0.1 then
			            vnew[k]=-self.lastvelocity[k]*self.springiness
		            end
	            end
            end
            
            if not vector.equals(new_velocity,vnew) then
	            self.collided = true
            else
	            if self.collided then
		            vnew = vector.new(self.lastvelocity)
	            end
	            self.collided = false
            end
            new_velocity = vnew
        end
    end

    self.object:set_velocity(new_velocity)

end

