-- Using TenPlus1's Mobs Redo
-- Shadow Realm Mobs

-- Asp
mobs:register_mob("shadowrealm:asp", {
	physical = true,
	collisionbox = {0.5, 1, 0.5, -0.5, -2, -0.5},
	visual = "mesh",
	mesh = "shadowrealm_asp.b3d",
	textures = {"shadowrealm_asp.png"},
	visual_size = {x=3,y=3,z=3},
	type = "monster",
	hp_min = 20,
	hp_max = 40,
	walk_velocity = 2,
	run_velocity = 3,
	stand_chance = 50,
	walk_chance = 50,
	jump = true,
	jump_height = 2,
	runaway = false,
	pushable = true,
	view_range = 10,
	damage = 5,
	knock_back = true,
	fear_height = 10,
	fall_damage = true,
	water_damage = 1,
	lava_damage = 5,
	light_damage = 0,
	suffocation = true,
	floats = 0,
	docile_by_day = false,
	attack_chance = 100,
	attack_monsters = false,
	attack_animals = true,
	attack_npcs = true,
	attack_players = true,
	attack_type = "dogfight",
	animation = {
		stand_start = 1,
		stand_end = 10,
		stand_speed = 24,
		walk_start = 1,
		walk_end = 10,
		walk_speed = 24,
		punch_start = 11,
		punch_end = 31,
		punch_speed = 24,
	},
	sounds = {
		attack = "shadowrealm_hiss.ogg",
		damage = "shadowrealm_hiss.ogg",
	},
	drops = {
		{
			name = "shadowrealm:asp_meat",
			chance = 2,
			min = 0, max = 2,
		},
		{
			name = "shadowrealm:asp_fang",
			chance = 1,
			min = 1, max = 2,
		},
	},
	max_speed = 2,
	jump_height = 1,
	view_range = 10,
})

-- Gargantuan
mobs:register_mob("shadowrealm:gargantuan", {
	physical = true,
	collisionbox = {0.5, 1, 0.5, -0.5, -2, -0.5},
	visual = "mesh",
	mesh = "shadowrealm_gargantuan.b3d",
	textures = {"shadowrealm_gargantuan.png"},
	visual_size = {x=6,y=6,z=6},
	type = "monster",
	hp_min = 200,
	hp_max = 300,
	walk_velocity = 6,
	run_velocity = 8,
	stand_chance = 50,
	walk_chance = 50,
	jump = true,
	jump_height = 2,
	runaway = false,
	pushable = true,
	view_range = 10,
	damage = 8,
	rotate = 270,
	knock_back = true,
	fear_height = 10,
	fall_damage = true,
	water_damage = 1,
	lava_damage = 5,
	light_damage = 0,
	suffocation = true,
	floats = 0,
	docile_by_day = false,
	attack_chance = 100,
	attack_monsters = false,
	attack_animals = true,
	attack_npcs = true,
	attack_players = true,
	attack_type = "dogfight",
	animation = {
		stand_start = 1,
		stand_end = 6,
		stand_speed = 24,
		walk_start = 1,
		walk_end = 6,
		walk_speed = 24,
		punch_start = 7,
		punch_end = 10,
		punch_speed = 24,
	},
	sounds = {
		attack = "shadowrealm_growl_01.ogg",
		damage = "shadowrealm_growl_02.ogg",
	},
	drops = {},
	max_speed = 10,
	jump_height = 1,
	view_range = 10,
	on_die = realm.on_gargantuan_death
})
