--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]




local modpath = minetest.get_modpath(minetest.get_current_modname())
local tropicalrainforestresourcemodpath = minetest.get_modpath("awuuwa_biomes_resource_tropical_rainforest")
local mushroomsresourcemodpath = minetest.get_modpath("awuuwa_biomes_resource_mushrooms")

local whatdirtweusing = "awuuwa_biomes_resource_mushrooms:brown_mushroom"

if minetest.get_modpath("default") then
whatdirtweusing = "default:dirt"
end

minetest.register_biome({
	name = "awuuwa_biomes_tropical_rainforest",
	node_top = "awuuwa_biomes_resource_tropical_rainforest:dirt_with_tropical_rainforest_grass",
	depth_top = 1,
	node_filler = whatdirtweusing,
	depth_filler = 3,
	node_riverbed = whatdirtweusing,
	depth_riverbed = 2,
--	node_cave_liquid = "default:water_source",
--    node_dungeon = "default:junglewood",
--    node_dungeon_alt = "default:junglewood",
	vertical_blend = 1,
--	node_river_water = "default:water_source",
	y_max = 40,
	y_min = 1,
    heat_point = 99,--86
    humidity_point = 99,--80
})

--minetest.register_alias("swamp:mangrove_leaves", "awuuwa_biomes_resource_tropical_rainforest:tree_leaves")


minetest.register_decoration({
	name = "awuuwa_biomes_tropical_rainforest:tree1",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_resource_tropical_rainforest:dirt_with_tropical_rainforest_grass"},
	sidelen = 16,
    fill_ratio = 0.03,
	biomes = {"awuuwa_biomes_tropical_rainforest"},
--	y_max = 100,
--	y_min = 1,
	schematic = modpath .. "/schematics/tropicaltree1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_tropical_rainforest:red_mushroom_1",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_resource_tropical_rainforest:dirt_with_tropical_rainforest_grass"},
	sidelen = 16,
    fill_ratio = 0.00005,
	biomes = {"awuuwa_biomes_tropical_rainforest"},
--	y_max = 100,
--	y_min = 1,
	schematic = mushroomsresourcemodpath .. "/schematics/red_mushroom_1.mts",
	flags = "place_center_x, place_center_z",
--	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_tropical_rainforest:brown_mushroom_1",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_resource_tropical_rainforest:dirt_with_tropical_rainforest_grass"},
	sidelen = 16,
    fill_ratio = 0.0001,
	biomes = {"awuuwa_biomes_tropical_rainforest"},
--	y_max = 100,
--	y_min = 1,
	schematic = mushroomsresourcemodpath .. "/schematics/brown_mushroom_1.mts",
	flags = "place_center_x, place_center_z",
--	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_tropical_rainforest:brown_mushroom_2",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_resource_tropical_rainforest:dirt_with_tropical_rainforest_grass"},
	sidelen = 16,
    fill_ratio = 0.00005,
	biomes = {"awuuwa_biomes_tropical_rainforest"},
--	y_max = 100,
--	y_min = 1,
	schematic = mushroomsresourcemodpath .. "/schematics/brown_mushroom_2.mts",
	flags = "place_center_x, place_center_z",
--	rotation = "random"
})


if minetest.get_modpath("default") then
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"awuuwa_biomes_resource_tropical_rainforest:dirt_with_tropical_rainforest_grass"},
	sidelen = 16,
	fill_ratio = 0.3,
	biomes = {"awuuwa_biomes_tropical_rainforest"},
	decoration = {
		"default:junglegrass", "default:fern_2", "default:fern_3",
	}
})
end

if minetest.get_modpath("flowers") then
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"awuuwa_biomes_resource_tropical_rainforest:dirt_with_tropical_rainforest_grass"},
	sidelen = 16,
	fill_ratio = 0.01,
	biomes = {"awuuwa_biomes_tropical_rainforest"},
	decoration = {
		"flowers:mushroom_brown", "flowers:mushroom_red",
	}
})
end
