--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]




local modpath = minetest.get_modpath(minetest.get_current_modname())

minetest.register_biome({
	name = "awuuwa_biomes_outback",
	node_top = "default:dry_dirt",
	depth_top = 1,
	node_filler = "default:dry_dirt",
	depth_filler = 1,
	node_riverbed = "default:dirt",
	node_stone = "default:desert_stone",
	depth_riverbed = 2,
	node_cave_liquid = "default:water_source",
	node_dungeon = "default:desert_sandstone_bricks",
	node_dungeon_alt = "default:desert_sandstone",
	vertical_blend = 1,
--	node_river_water = "default:water_source",
	y_max = 31000,
	y_min = 5,
    heat_point = 70,
    humidity_point = 32,
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dry_dirt"},
	sidelen = 4,
	fill_ratio = .4,
	biomes = {"awuuwa_biomes_outback"},
	y_max = 31000,
	y_min = 1,
	decoration = "awuuwa_biomes_resource_outback:dry_dirt_with_outback_grass",
	place_offset_y = -1,
	flags = "force_placement",
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dry_dirt"},
	sidelen = 4,
	fill_ratio = .3,
	biomes = {"awuuwa_biomes_outback"},
	y_max = 31000,
	y_min = 1,
	decoration = "awuuwa_biomes_resource_outback:red_sand",
	place_offset_y = -1,
	flags = "force_placement",
})


minetest.register_decoration({
	name = "awuuwa_biomes_outback:bush",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_resource_outback:dry_dirt_with_outback_grass", "awuuwa_biomes_resource_outback:dirt_with_outback_grass", "default:dry_dirt_with_dry_grass", "default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.02,
	biomes = {"awuuwa_biomes_outback"},
	y_max = 31000,
	y_min = 1,
	schematic = minetest.get_modpath("awuuwa_biomes_resource_outback") .. "/schematics/outbacktree.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	name = "awuuwa_biomes_outback:bush",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_resource_outback:dry_dirt_with_outback_grass", "awuuwa_biomes_resource_outback:dirt_with_outback_grass", "default:dry_dirt_with_dry_grass", "default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.01,
	biomes = {"awuuwa_biomes_outback"},
	y_max = 31000,
	y_min = 1,
	schematic = minetest.get_modpath("default") .. "/schematics/acacia_bush.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"awuuwa_biomes_resource_outback:dry_dirt_with_outback_grass", "awuuwa_biomes_resource_outback:dirt_with_outback_grass", "default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = {"awuuwa_biomes_outback"},
	decoration = {
		"awuuwa_biomes_resource_plants:vegetation_3",
	}
})

--[[for i = 1, 5 do
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"awuuwa_biomes_resource_outback:dry_dirt_with_outback_grass", "awuuwa_biomes_resource_outback:dirt_with_outback_grass", "default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.09,
	biomes = {"awuuwa_biomes_outback"},
	decoration = {
		"default:grass_" .. 5 - i,
	}
})
end]]
