--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]



local modpath = minetest.get_modpath(minetest.get_current_modname())

minetest.register_biome({
	name = "awuuwa_biomes_xeric_shrubland",
	node_top = "default:desert_sand",
	depth_top = 1,
	node_filler = "default:desert_sand",
	depth_filler = 1,
	node_riverbed = "default:desert_sand",
	node_stone = "default:desert_stone",
	depth_riverbed = 2,
	node_cave_liquid = "default:water_source",
	node_dungeon = "default:desert_sandstone_bricks",
	node_dungeon_alt = "default:desert_sandstone",
	vertical_blend = 1,
--	node_river_water = "default:water_source",
	y_max = 31000,
	y_min = 5,
    heat_point = 90,
    humidity_point = 32,
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:desert_sand"},
	sidelen = 4,
	fill_ratio = .7,
	biomes = {"awuuwa_biomes_xeric_shrubland"},
	y_max = 31000,
	y_min = 1,
	decoration = "default:dry_dirt_with_dry_grass",
	place_offset_y = -1,
	flags = "force_placement",
})


minetest.register_decoration({
	name = "awuuwa_biomes_xeric_shrubland:bush",
	deco_type = "schematic",
	place_on = {"default:desert_sand", "default:dry_dirt_with_dry_grass"},
	sidelen = 16,
	fill_ratio = 0.01,
	biomes = {"awuuwa_biomes_xeric_shrubland"},
	y_max = 31000,
	y_min = 1,
	schematic = minetest.get_modpath("default") .. "/schematics/acacia_bush.mts",
	flags = "place_center_x, place_center_z",
})


for i = 1, 5 do
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:desert_sand", "default:dry_dirt_with_dry_grass"},
	sidelen = 16,
	fill_ratio = 0.09,
	biomes = {"awuuwa_biomes_xeric_shrubland"},
	decoration = {
		"default:grass_" .. 5 - i,
	}
})
end


minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:desert_sand", "default:dry_dirt_with_dry_grass"},
	sidelen = 16,
	fill_ratio = 0.1,
	biomes = {"awuuwa_biomes_xeric_shrubland"},
	decoration = {
		"flowers:rose", "flowers:dandelion_yellow", "flowers:viola", "flowers:dandelion_white"
	}
})


for i = 1, 5 do
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:desert_sand", "default:dry_dirt_with_dry_grass"},
	sidelen = 16,
	fill_ratio = 0.09,
	biomes = {"awuuwa_biomes_xeric_shrubland"},
	decoration = {
		"default:dry_grass_" .. 5 - i,
	}
})
end


minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:desert_sand", "default:dry_dirt_with_dry_grass"},
	sidelen = 16,
	fill_ratio = 0.03,
	biomes = {"awuuwa_biomes_xeric_shrubland"},
	decoration = {
		"default:dry_shrub",
	}
})
