--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]




local modpath = minetest.get_modpath(minetest.get_current_modname())
local mushroomsresourcemodpath = minetest.get_modpath("awuuwa_biomes_resource_mushrooms")

minetest.register_biome({
	name = "awuuwa_biomes_winter_forest",
	node_dust = "default:snow",
	node_top = "default:dirt_with_snow",
	depth_top = 1,
	node_filler = "default:dirt",
	depth_filler = 3,
	node_riverbed = "default:clay",
	depth_riverbed = 2,
	node_cave_liquid = "default:water_source",
	node_dungeon = "default:cobble",
	node_dungeon_alt = "default:mossycobble",
	vertical_blend = 1,
--	node_river_water = "default:water_source",
	y_max = 60,
	y_min = 9,
    heat_point = 28,
    humidity_point = 72,
--[[
    heat_point = 80,
    humidity_point = 98,
]]
})

--[[	minetest.register_decoration({
		name = "awuuwa_biomes_winter_forest:glassi",
		deco_type = "schematic",
		place_on = {"default:dirt_with_coniferous_litter"},
		sidelen = 16,
    fill_ratio = 0.25,
		biomes = {"awuuwa_biomes_winter_forest"},
		y_max = 10,
		y_min = -100,
		flags = "force_placement",
		schematic = modpath .. "/schematics/glasspillar.mts",
	})]]

minetest.register_decoration({
	name = "awuuwa_biomes_winter_forest:pine_tree",
	deco_type = "schematic",
	place_on = {"default:dirt_with_snow", "default:dirt_with_coniferous_litter"},
	sidelen = 16,
	fill_ratio = .018,
--[[	noise_params = {
		offset = 0.010,
		scale = 0.048,
		spread = {x = 250, y = 250, z = 250},
		seed = 2,
		octaves = 3,
		persist = 0.66
	},]]
	biomes = {"awuuwa_biomes_winter_forest"},
	y_max = 31000,
	y_min = 2,
	schematic = minetest.get_modpath("default") .. "/schematics/pine_tree.mts",
	flags = "place_center_x, place_center_z",
})

minetest.register_decoration({
	name = "awuuwa_biomes_winter_forest:spruce_tree",
	deco_type = "schematic",
	place_on = {"default:dirt_with_snow", "default:dirt_with_coniferous_litter", "default:dirt"},--"default:dirt_with_snow", "default:dirt_with_coniferous_litter", "default:dirt"
	sidelen = 16,
	fill_ratio = .018,
--[[	noise_params = {
		offset = 0.010,
		scale = 0.048,
		spread = {x = 250, y = 250, z = 250},
		seed = 2,
		octaves = 3,
		persist = 0.66
	},]]
	biomes = {"awuuwa_biomes_winter_forest"},
	y_max = 31000,
	y_min = 2,
	schematic = minetest.get_modpath("spruce_tree") .. "/schematics/spruce_tree.mts",
	flags = "place_center_x, place_center_z",
})
minetest.register_decoration({
	name = "awuuwa_biomes_winter_forest:small_pine_tree",
	deco_type = "schematic",
	place_on = {"default:dirt_with_snow", "default:dirt_with_coniferous_litter"},
	sidelen = 16,
	fill_ratio = .018,
	biomes = {"awuuwa_biomes_winter_forest"},
	y_max = 31000,
	y_min = 4,
	schematic = minetest.get_modpath("default") .. "/schematics/small_pine_tree.mts",
	flags = "place_center_x, place_center_z",
})




minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_snow"},
	sidelen = 16,
	fill_ratio = 0.015,
	biomes = {"awuuwa_biomes_winter_forest"},
	decoration = {
		"default:snowblock",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_snow"},
	sidelen = 16,
	fill_ratio = 0.1,
	biomes = {"awuuwa_biomes_winter_forest"},
	decoration = {
		"default:snow",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_snow"},
	sidelen = 16,
	fill_ratio = 0.015,
	biomes = {"awuuwa_biomes_winter_forest"},
	decoration = {
		"default:stone",
	}
})
--[[minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_snow"},
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = {"awuuwa_biomes_winter_forest"},
	decoration = {
		"default:fern_1", "default:fern_2", "default:fern_3",
	}
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dirt_with_snow"},
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = {"awuuwa_biomes_winter_forest"},
	decoration = {
		"awuuwa_biomes_resource_plants:plant",
	}
})
]]
