--[[
     This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>. 
]]



local modpath = minetest.get_modpath(minetest.get_current_modname())

minetest.register_biome({
    name = "awuuwa_biomes_scifi_biome",
    node_top = "awuuwa_biomes_scifi_biome:digisoil",
    depth_top = 1,
    node_filler = "awuuwa_biomes_scifi_biome:metalworks",
    depth_filler = 3,
    node_riverbed = "awuuwa_biomes_scifi_biome:digisoil",
    depth_riverbed = 2,
	node_stone = "awuuwa_biomes_scifi_biome:metalworks",--deep_machinery
    node_dungeon = "awuuwa_biomes_scifi_biome:purple_thing",
    node_dungeon_alt = "awuuwa_biomes_scifi_biome:purple_thing",
    y_max = 40,
    y_min = 10,
    heat_point = 0,--45
    humidity_point = 0,--45
})

--[[minetest.register_biome({
	name = "awuuwa_biomes_scifi_biome_under",
	node_cave_liquid = {"awuuwa_biomes_scifi_biome:swamp_water_source", "default:lava_source"},
    node_dungeon = "awuuwa_biomes_scifi_biome:purple_thing",
    node_dungeon_alt = "awuuwa_biomes_scifi_biome:purple_thing",
	node_stone = "awuuwa_biomes_scifi_biome:foundationrock",
	y_max = 10,
	y_min = 1,
    heat_point = 45,
    humidity_point = 45,
})]]

--[[

between desert and silversand desert
    y_max = 100,
    y_min = -1,
    heat_point = 70,
    humidity_point = 2,


	silversand deset lowlands and coasts and some islands
    y_max = 10,
    y_min = -1,
    heat_point = 35,
    humidity_point = 2,

]]

--[[minetest.register_biome({
	name = "awuuwa_biomes_scifi_biome",
	node_top = "awuuwa_biomes_scifi_biome:mud",
	depth_top = 1,
	node_filler = "awuuwa_biomes_scifi_biome:mud",
	depth_filler = 3,
	node_riverbed = "awuuwa_biomes_scifi_biome:mud",
	depth_riverbed = 2,
	node_stone = "awuuwa_biomes_scifi_biome:foundationrock",
	node_cave_liquid = "awuuwa_biomes_scifi_biome:swamp_water_source",
    node_dungeon = "awuuwa_biomes_scifi_biome:deep_machinery",
    node_dungeon_alt = "awuuwa_biomes_scifi_biome:metalworks",
	vertical_blend = 1,
	node_river_water = "awuuwa_biomes_scifi_biome:swamp_water_source",
	y_max = -1,
	y_min = -255,
    heat_point = 80,
    humidity_point = 98,
})]]

minetest.register_decoration({
	name = "awuuwa_biomes_scifi_biome_worldgen:tree1",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil", "awuuwa_biomes_scifi_biome:mud", "awuuwa_biomes_scifi_biome:root_with_mud"},
	sidelen = 16,
	noise_params = {
		offset = 0.02,
		scale = 0.001,
		spread = {x = 250, y = 250, z = 250},
		seed = 201,
		octaves = 1,
		persist = 0.11
	},
	biomes = {"awuuwa_biomes_scifi_biome"},
--	y_max = 100,
--	y_min = 1,
	schematic = modpath .. "/schematics/tree1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil"},
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = {"awuuwa_biomes_scifi_biome"},
	decoration = {
		"awuuwa_biomes_scifi_biome:digiflower", "awuuwa_biomes_scifi_biome:digiflower", "awuuwa_biomes_scifi_biome:digiflower",
	}
})

minetest.register_decoration({
	name = "awuuwa_biomes_scifi_biome_worldgen:lampthing1",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil"},
	sidelen = 16,
	noise_params = {
		offset = 0.02,
		scale = 0.001,
		spread = {x = 250, y = 250, z = 250},
		seed = 201,
		octaves = 1,
		persist = 0.11
	},
	biomes = {"awuuwa_biomes_scifi_biome"},
--	y_max = 100,
--	y_min = 2,
	schematic = modpath .. "/schematics/lampthing1.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})



--[[minetest.register_decoration({
    name = "awuuwa_biomes_scifi_biome:swamp_source_2",
    deco_type = "schematic",
    place_on = {"awuuwa_biomes_scifi_biome:digisoil", "terraria:root_with_mud"},
    sidelen = 16,
    noise_params = {
        offset = 0.25,
        scale = 0.25,
        spread = {x = 250, y = 250, z = 250},
        seed = 78,
        octaves = 3,
        persist = 2
    },
    biomes = {"awuuwa_biomes_scifi_biome"},
    height = 1,
    y_min = 0,
    y_max = 3,
    place_offset_y = -1,
    schematic = modpath .. "/schematics/swamp_source_2.mts",
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
})

minetest.register_decoration({
    name = "awuuwa_biomes_scifi_biome:swamp_source_1",
    deco_type = "schematic",
    place_on = {"awuuwa_biomes_scifi_biome:digisoil", "terraria:root_with_mud"},
    sidelen = 16,
    noise_params = {
        offset = 0.072,
        scale = 0.108,
        spread = {x = 250, y = 250, z = 250},
        seed = 78,
        octaves = 3,
        persist = 2
    },
    biomes = {"awuuwa_biomes_scifi_biome"},
    height = 1,
    y_min = 0,
    y_max = 10,
    place_offset_y = -1,
    schematic = modpath .. "/schematics/swamp_source_1.mts",
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
})]]

--[[minetest.register_decoration({
	deco_type = "simple",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil", "awuuwa_biomes_scifi_biome:mud", "awuuwa_biomes_scifi_biome:root_with_mud"},
	sidelen = 16,
	fill_ratio = 0.07,
	biomes = {"awuuwa_biomes_scifi_biome"},
	decoration = "fireflies:firefly",
})]]

--[[minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:water_source", "awuuwa_biomes_scifi_biome:swamp_water_source"},
    sidelen = 16,
    fill_ratio = 0.15,
    biomes = {"awuuwa_biomes_scifi_biome", "awuuwa_biomes_scifi_biome_ocean"},
    decoration = "flowers:waterlily_waving",
})]]

--[[minetest.register_decoration({
	deco_type = "simple",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil", "awuuwa_biomes_scifi_biome:mud", "awuuwa_biomes_scifi_biome:root_with_mud"},
	sidelen = 16,
	fill_ratio = 0.15,
	biomes = {"awuuwa_biomes_scifi_biome"},
	decoration = {
		"default:junglegrass", "default:fern_2", "default:fern_3",
	}
})]]

--[[minetest.register_decoration({
	deco_type = "simple",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil", "awuuwa_biomes_scifi_biome:mud", "awuuwa_biomes_scifi_biome:root_with_mud"},
	sidelen = 16,
	y_max = 10,
	y_min = 1,
	fill_ratio = 0.05,
	biomes = {"awuuwa_biomes_scifi_biome"},
	decoration = {
		"flowers:mushroom_brown",
	}
})]]



--[[
minetest.register_decoration({
	name = "awuuwa_biomes_scifi_biome:mangrove_tree_2",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil", "awuuwa_biomes_scifi_biome:mud", "awuuwa_biomes_scifi_biome:root_with_mud"},
	sidelen = 16,
	noise_params = {
		offset = 0.015,
		scale = 0.001,
		spread = {x = 250, y = 250, z = 250},
		seed = 201,
		octaves = 1,
		persist = 0.11
	},
	biomes = {"awuuwa_biomes_scifi_biome"},
	y_max = 10,
	y_min = 1,
	schematic = modpath .. "/schematics/mangrove_tree_2.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_scifi_biome:mangrove_tree_3",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil", "awuuwa_biomes_scifi_biome:mud", "awuuwa_biomes_scifi_biome:root_with_mud"},
	sidelen = 16,
	noise_params = {
		offset = 0.015,
		scale = 0.001,
		spread = {x = 250, y = 250, z = 250},
		seed = 201,
		octaves = 1,
		persist = 0.11
	},
	biomes = {"awuuwa_biomes_scifi_biome"},
	y_max = 10,
	y_min = 1,
	schematic = modpath .. "/schematics/mangrove_tree_3.mts",
	flags = "place_center_x, place_center_z",
	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_scifi_biome:mangrove_tree_1_3",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil", "awuuwa_biomes_scifi_biome:mud", "awuuwa_biomes_scifi_biome:root_with_mud"},
	sidelen = 16,
	noise_params = {
		offset = 0.015,
		scale = 0.001,
		spread = {x = 250, y = 250, z = 250},
		seed = 201,
		octaves = 1,
		persist = 0.11
	},
	biomes = {"awuuwa_biomes_scifi_biome"},
	y_max = -1,
	y_min = -1,
	schematic = modpath .. "/schematics/mangrove_tree_1_3.mts",
	flags = "place_center_x, place_center_z, force_placement",
	rotation = "random"
})

minetest.register_decoration({
	name = "awuuwa_biomes_scifi_biome:mangrove_tree_2_2",
	deco_type = "schematic",
	place_on = {"awuuwa_biomes_scifi_biome:digisoil", "awuuwa_biomes_scifi_biome:mud", "awuuwa_biomes_scifi_biome:root_with_mud"},
	sidelen = 16,
	noise_params = {
		offset = 0.015,
		scale = 0.001,
		spread = {x = 250, y = 250, z = 250},
		seed = 201,
		octaves = 1,
		persist = 0.11
	},
	biomes = {"awuuwa_biomes_scifi_biome"},
	y_max = -2,
	y_min = -2,
	schematic = modpath .. "/schematics/mangrove_tree_2_2.mts",
	flags = "place_center_x, place_center_z, force_placement",
	rotation = "random"
})]]
